/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.regex;

import org.basex.query.util.regex.Escape;
import org.basex.query.util.regex.LineBorder;
import org.basex.query.util.regex.RegExp;
import org.basex.util.Util;

public final class WordBoundary
extends RegExp {
    private final String img;
    private static final WordBoundary[] INSTANCES = new WordBoundary[4];

    private WordBoundary(boolean positive, boolean multi) {
        String eos = LineBorder.eos(multi);
        this.img = positive ? "(?:(?<=[" + Escape.WORD + "])(?:(?=[" + Escape.NOT_WORD + "])|" + eos + ")|(?<=(?:^|[" + Escape.NOT_WORD + "]))(?=[" + Escape.WORD + "]))" : "(?:(?<=[" + Escape.WORD + "])(?=[" + Escape.WORD + "])|(?<=(?:^|[" + Escape.NOT_WORD + "]))(?:(?=[" + Escape.NOT_WORD + "])|" + eos + ")|^" + eos + ")";
    }

    public static WordBoundary get(String esc, boolean multi) {
        boolean positive = switch (esc.charAt(1)) {
            case 'b' -> true;
            case 'B' -> false;
            default -> throw Util.notExpected();
        };
        int pos = (positive ? 2 : 0) + (multi ? 1 : 0);
        if (INSTANCES[pos] == null) {
            WordBoundary.INSTANCES[pos] = new WordBoundary(positive, multi);
        }
        return INSTANCES[pos];
    }

    @Override
    void toRegEx(StringBuilder sb) {
        sb.append(this.img);
    }
}

