/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.tools.xsd;

import java.io.IOException;
import java.io.Writer;
import org.apache.rat.report.xml.writer.XmlWriter;

public class XsdWriter {
    private final XmlWriter writer;

    public XsdWriter(Writer writer) {
        this.writer = new XmlWriter(writer);
    }

    public XsdWriter init() throws IOException {
        this.writer.startDocument().openElement("xs:schema").attribute("attributeFormDefault", "unqualified").attribute("xmlns:xs", "http://www.w3.org/2001/XMLSchema");
        return this;
    }

    public void finish() throws IOException {
        this.writer.closeDocument();
    }

    private void writeAttributes(String[] attributeMap) throws IOException {
        if (attributeMap != null) {
            for (int i2 = 0; i2 < attributeMap.length; i2 += 2) {
                this.writer.attribute(attributeMap[i2], attributeMap[i2 + 1]);
            }
        }
    }

    public XsdWriter open(Type type, String ... attributeMap) throws IOException {
        this.writer.openElement(type.elementName);
        this.writeAttributes(attributeMap);
        return this;
    }

    public XsdWriter attribute(String name, String ... attributeMap) throws IOException {
        this.writer.openElement("xs:attribute").attribute("name", name);
        this.writeAttributes(attributeMap);
        this.writer.closeElement();
        return this;
    }

    public XsdWriter close(Type type) throws IOException {
        this.writer.closeElement(type.elementName);
        return this;
    }

    public static enum Type {
        ELEMENT("xs:element"),
        ATTRIBUTE("xs:attribute"),
        COMPLEX("xs:complexType"),
        SEQUENCE("xs:sequence"),
        SIMPLE("xs:simpleContent"),
        EXTENSION("xs:extension"),
        CHOICE("xs:choice"),
        COMPLEX_CONTENT("xs:complexContent");

        private final String elementName;

        private Type(String name) {
            this.elementName = name;
        }
    }
}

