/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.kill;

import java.util.UUID;
import org.apache.ignite.IgniteException;
import org.apache.ignite.internal.dto.IgniteDataTransferObject;
import org.apache.ignite.internal.management.snapshot.SnapshotJob;
import org.apache.ignite.internal.processors.cache.persistence.snapshot.SnapshotMXBeanImpl;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorOneNodeTask;

@GridInternal
public class SnapshotCancelTask
extends VisorOneNodeTask<CancelSnapshotArg, String> {
    private static final long serialVersionUID = 0L;

    @Override
    protected VisorJob<CancelSnapshotArg, String> job(CancelSnapshotArg arg) {
        return new SnapshotCancelJob(arg, this.debug);
    }

    public static abstract class CancelSnapshotArg
    extends IgniteDataTransferObject {
        public abstract UUID requestId();

        public abstract String snapshotName();
    }

    private static class SnapshotCancelJob
    extends SnapshotJob<CancelSnapshotArg, String> {
        private static final long serialVersionUID = 0L;

        protected SnapshotCancelJob(CancelSnapshotArg taskArg, boolean debug) {
            super(taskArg, debug);
        }

        @Override
        protected String run(CancelSnapshotArg taskArg) throws IgniteException {
            if (taskArg.requestId() != null) {
                new SnapshotMXBeanImpl(this.ignite.context()).cancelSnapshotOperation(taskArg.requestId().toString());
                return "Snapshot operation cancelled [id=" + taskArg.requestId() + "].";
            }
            new SnapshotMXBeanImpl(this.ignite.context()).cancelSnapshot(taskArg.snapshotName());
            return "Snapshot operation cancelled [snapshot=" + taskArg.snapshotName() + "].";
        }
    }
}

