/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.cli.core.repl;

import io.micronaut.context.annotation.Value;
import jakarta.inject.Singleton;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.ignite3.internal.cli.core.repl.SessionInfo;
import org.apache.ignite3.internal.cli.core.rest.ApiClientFactory;
import org.apache.ignite3.internal.cli.event.ConnectionEventListener;
import org.apache.ignite3.internal.cli.event.EventPublisher;
import org.apache.ignite3.internal.cli.event.Events;
import org.apache.ignite3.internal.cli.logger.CliLoggers;
import org.apache.ignite3.internal.logger.IgniteLogger;
import org.apache.ignite3.internal.thread.NamedThreadFactory;
import org.apache.ignite3.rest.client.api.NodeManagementApi;
import org.apache.ignite3.rest.client.invoker.ApiException;
import org.jetbrains.annotations.Nullable;

@Singleton
public class ConnectionHeartBeat
implements ConnectionEventListener {
    private static final IgniteLogger LOG = CliLoggers.forClass(ConnectionHeartBeat.class);
    private final long cliCheckConnectionPeriodSecond;
    @Nullable
    private ScheduledExecutorService scheduledConnectionHeartbeatExecutor;
    private final ApiClientFactory clientFactory;
    private final EventPublisher eventPublisher;
    private final AtomicBoolean connected = new AtomicBoolean(false);
    private final Lock lock = new ReentrantLock();

    public ConnectionHeartBeat(@Value(value="${cli.check.connection.period.second:5}") long cliCheckConnectionPeriodSecond, ApiClientFactory clientFactory, EventPublisher eventPublisher) {
        this.clientFactory = clientFactory;
        this.eventPublisher = eventPublisher;
        this.cliCheckConnectionPeriodSecond = cliCheckConnectionPeriodSecond;
    }

    @Override
    public void onConnect(SessionInfo sessionInfo) {
        if (this.connected.compareAndSet(false, true)) {
            this.eventPublisher.publish(Events.connectionRestored());
        }
        this.lock.lock();
        try {
            if (this.scheduledConnectionHeartbeatExecutor == null) {
                this.scheduledConnectionHeartbeatExecutor = Executors.newScheduledThreadPool(1, new NamedThreadFactory("cli-check-connection-thread", LOG));
                this.scheduledConnectionHeartbeatExecutor.scheduleAtFixedRate(() -> this.pingConnection(sessionInfo.nodeUrl()), 0L, this.cliCheckConnectionPeriodSecond, TimeUnit.SECONDS);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void onDisconnect() {
        this.lock.lock();
        try {
            if (this.scheduledConnectionHeartbeatExecutor != null) {
                this.scheduledConnectionHeartbeatExecutor.shutdownNow();
                this.scheduledConnectionHeartbeatExecutor = null;
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void pingConnection(String nodeUrl) {
        block3: {
            try {
                new NodeManagementApi(this.clientFactory.getClient(nodeUrl)).nodeState();
                if (this.connected.compareAndSet(false, true)) {
                    this.eventPublisher.publish(Events.connectionRestored());
                }
            }
            catch (ApiException exception) {
                if (!this.connected.compareAndSet(true, false)) break block3;
                this.eventPublisher.publish(Events.connectionLost());
            }
        }
    }
}

