/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.replication;

import java.nio.ByteBuffer;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.network.serialization.MessageDeserializer;
import org.apache.ignite3.internal.network.serialization.MessageMappingException;
import org.apache.ignite3.internal.network.serialization.MessageReader;
import org.apache.ignite3.internal.partition.replicator.network.PartitionReplicationMessagesFactory;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadOnlyDirectSingleRowReplicaRequest;
import org.apache.ignite3.internal.partition.replicator.network.replication.ReadOnlyDirectSingleRowReplicaRequestBuilder;
import org.apache.ignite3.internal.partition.replicator.network.replication.RequestType;
import org.apache.ignite3.internal.replicator.message.ReplicationGroupIdMessage;

class ReadOnlyDirectSingleRowReplicaRequestDeserializer
implements MessageDeserializer<ReadOnlyDirectSingleRowReplicaRequest> {
    private final ReadOnlyDirectSingleRowReplicaRequestBuilder msg;

    ReadOnlyDirectSingleRowReplicaRequestDeserializer(PartitionReplicationMessagesFactory messageFactory) {
        this.msg = messageFactory.readOnlyDirectSingleRowReplicaRequest();
    }

    @Override
    public Class<ReadOnlyDirectSingleRowReplicaRequest> klass() {
        return ReadOnlyDirectSingleRowReplicaRequest.class;
    }

    @Override
    public ReadOnlyDirectSingleRowReplicaRequest getMessage() {
        return this.msg.build();
    }

    @Override
    public boolean readMessage(MessageReader reader) throws MessageMappingException {
        if (!reader.beforeMessageRead()) {
            return false;
        }
        switch (reader.state()) {
            case 0: {
                Object tmp = reader.readBoxedLong("enlistmentConsistencyToken");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.enlistmentConsistencyToken((Long)tmp);
                reader.incrementState();
            }
            case 1: {
                Object tmp = (ReplicationGroupIdMessage)reader.readMessage("groupId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.groupId((ReplicationGroupIdMessage)tmp);
                reader.incrementState();
            }
            case 2: {
                Object tmp = reader.readByteBuffer("primaryKey");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.primaryKey((ByteBuffer)tmp);
                reader.incrementState();
            }
            case 3: {
                int shiftedId = reader.readInt("requestType");
                if (!reader.isLastRead()) {
                    return false;
                }
                RequestType tmp = shiftedId == 0 ? null : RequestType.fromId(shiftedId - 1);
                this.msg.requestType(tmp);
                reader.incrementState();
            }
            case 4: {
                int tmp = reader.readInt("schemaVersion");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.schemaVersion(tmp);
                reader.incrementState();
            }
            case 5: {
                int tmp = reader.readInt("tableId");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.tableId(tmp);
                reader.incrementState();
            }
            case 6: {
                HybridTimestamp tmp = reader.readHybridTimestamp("timestamp");
                if (!reader.isLastRead()) {
                    return false;
                }
                this.msg.timestamp(tmp);
                reader.incrementState();
            }
        }
        return reader.afterMessageRead(ReadOnlyDirectSingleRowReplicaRequest.class);
    }
}

