/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.model;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.model.ModelInformation;
import org.apache.iotdb.commons.model.ModelStatus;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class ModelTable {
    private final Map<String, ModelInformation> modelInfoMap = new ConcurrentHashMap<String, ModelInformation>();

    public boolean containsModel(String modelId) {
        return this.modelInfoMap.containsKey(modelId);
    }

    public void addModel(ModelInformation modelInformation) {
        this.modelInfoMap.put(modelInformation.getModelName(), modelInformation);
    }

    public void removeModel(String modelId) {
        this.modelInfoMap.remove(modelId);
    }

    public List<ModelInformation> getAllModelInformation() {
        return new ArrayList<ModelInformation>(this.modelInfoMap.values());
    }

    public ModelInformation getModelInformationById(String modelId) {
        if (this.modelInfoMap.containsKey(modelId)) {
            return this.modelInfoMap.get(modelId);
        }
        return null;
    }

    public void clearFailedModel() {
        for (ModelInformation modelInformation : this.modelInfoMap.values()) {
            if (modelInformation.getStatus() != ModelStatus.UNAVAILABLE) continue;
            this.modelInfoMap.remove(modelInformation.getModelName());
        }
    }

    public void updateModel(String modelName, ModelInformation modelInfo) {
        this.modelInfoMap.replace(modelName, modelInfo);
    }

    public void clear() {
        this.modelInfoMap.clear();
    }

    public void serialize(FileOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)this.modelInfoMap.size(), (OutputStream)stream);
        for (ModelInformation entry : this.modelInfoMap.values()) {
            entry.serialize(stream);
        }
    }

    public static ModelTable deserialize(InputStream stream) throws IOException {
        ModelTable modelTable = new ModelTable();
        int size = ReadWriteIOUtils.readInt((InputStream)stream);
        for (int i = 0; i < size; ++i) {
            modelTable.addModel(ModelInformation.deserialize(stream));
        }
        return modelTable;
    }
}

