/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.consensus.pipe.metric;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.iotdb.consensus.pipe.consensuspipe.ConsensusPipeConnector;

public class PipeConsensusSyncLagManager {
    long userWriteProgress = 0L;
    long minReplicateProgress = Long.MAX_VALUE;
    List<ConsensusPipeConnector> consensusPipeConnectorList = new CopyOnWriteArrayList<ConsensusPipeConnector>();

    private void updateReplicateProgress() {
        this.minReplicateProgress = Long.MAX_VALUE;
        if (this.consensusPipeConnectorList.isEmpty()) {
            return;
        }
        this.consensusPipeConnectorList.forEach(consensusPipeConnector -> {
            this.minReplicateProgress = Math.min(this.minReplicateProgress, consensusPipeConnector.getConsensusPipeReplicateProgress());
        });
    }

    private void updateUserWriteProgress() {
        if (this.consensusPipeConnectorList.isEmpty()) {
            this.userWriteProgress = 0L;
            return;
        }
        try {
            ConsensusPipeConnector connector = this.consensusPipeConnectorList.get(0);
            this.userWriteProgress = connector.getConsensusPipeCommitProgress();
        }
        catch (Exception e) {
            this.userWriteProgress = 0L;
        }
    }

    public void addConsensusPipeConnector(ConsensusPipeConnector consensusPipeConnector) {
        this.consensusPipeConnectorList.add(consensusPipeConnector);
    }

    public void removeConsensusPipeConnector(ConsensusPipeConnector connector) {
        this.consensusPipeConnectorList.remove(connector);
    }

    public long calculateSyncLag() {
        this.updateUserWriteProgress();
        this.updateReplicateProgress();
        if (this.minReplicateProgress == Long.MAX_VALUE) {
            return this.userWriteProgress;
        }
        return Math.max(this.userWriteProgress - this.minReplicateProgress, 0L);
    }

    private PipeConsensusSyncLagManager() {
    }

    public static PipeConsensusSyncLagManager getInstance(String groupId) {
        return PipeConsensusSyncLagManagerHolder.CONSENSU_GROUP_ID_2_INSTANCE_MAP.computeIfAbsent(groupId, key -> new PipeConsensusSyncLagManager());
    }

    public static void release(String groupId) {
        PipeConsensusSyncLagManagerHolder.CONSENSU_GROUP_ID_2_INSTANCE_MAP.remove(groupId);
    }

    public static void build() {
        PipeConsensusSyncLagManagerHolder.build();
    }

    private static class PipeConsensusSyncLagManagerHolder {
        private static Map<String, PipeConsensusSyncLagManager> CONSENSU_GROUP_ID_2_INSTANCE_MAP;

        private PipeConsensusSyncLagManagerHolder() {
        }

        private static void build() {
            if (CONSENSU_GROUP_ID_2_INSTANCE_MAP == null) {
                CONSENSU_GROUP_ID_2_INSTANCE_MAP = new ConcurrentHashMap<String, PipeConsensusSyncLagManager>();
            }
        }
    }
}

