/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class ModifySubscriptionRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=791");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=793");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=792");
    private final RequestHeader requestHeader;
    private final UInteger subscriptionId;
    private final Double requestedPublishingInterval;
    private final UInteger requestedLifetimeCount;
    private final UInteger requestedMaxKeepAliveCount;
    private final UInteger maxNotificationsPerPublish;
    private final UByte priority;

    public ModifySubscriptionRequest(RequestHeader requestHeader, UInteger subscriptionId, Double requestedPublishingInterval, UInteger requestedLifetimeCount, UInteger requestedMaxKeepAliveCount, UInteger maxNotificationsPerPublish, UByte priority) {
        this.requestHeader = requestHeader;
        this.subscriptionId = subscriptionId;
        this.requestedPublishingInterval = requestedPublishingInterval;
        this.requestedLifetimeCount = requestedLifetimeCount;
        this.requestedMaxKeepAliveCount = requestedMaxKeepAliveCount;
        this.maxNotificationsPerPublish = maxNotificationsPerPublish;
        this.priority = priority;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public UInteger getSubscriptionId() {
        return this.subscriptionId;
    }

    public Double getRequestedPublishingInterval() {
        return this.requestedPublishingInterval;
    }

    public UInteger getRequestedLifetimeCount() {
        return this.requestedLifetimeCount;
    }

    public UInteger getRequestedMaxKeepAliveCount() {
        return this.requestedMaxKeepAliveCount;
    }

    public UInteger getMaxNotificationsPerPublish() {
        return this.maxNotificationsPerPublish;
    }

    public UByte getPriority() {
        return this.priority;
    }

    protected ModifySubscriptionRequest(ModifySubscriptionRequestBuilder<?, ?> b) {
        super(b);
        this.requestHeader = ((ModifySubscriptionRequestBuilder)b).requestHeader;
        this.subscriptionId = ((ModifySubscriptionRequestBuilder)b).subscriptionId;
        this.requestedPublishingInterval = ((ModifySubscriptionRequestBuilder)b).requestedPublishingInterval;
        this.requestedLifetimeCount = ((ModifySubscriptionRequestBuilder)b).requestedLifetimeCount;
        this.requestedMaxKeepAliveCount = ((ModifySubscriptionRequestBuilder)b).requestedMaxKeepAliveCount;
        this.maxNotificationsPerPublish = ((ModifySubscriptionRequestBuilder)b).maxNotificationsPerPublish;
        this.priority = ((ModifySubscriptionRequestBuilder)b).priority;
    }

    public static ModifySubscriptionRequestBuilder<?, ?> builder() {
        return new ModifySubscriptionRequestBuilderImpl();
    }

    public ModifySubscriptionRequestBuilder<?, ?> toBuilder() {
        return new ModifySubscriptionRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ModifySubscriptionRequest)) {
            return false;
        }
        ModifySubscriptionRequest other = (ModifySubscriptionRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$requestedPublishingInterval = this.getRequestedPublishingInterval();
        Double other$requestedPublishingInterval = other.getRequestedPublishingInterval();
        if (this$requestedPublishingInterval == null ? other$requestedPublishingInterval != null : !((Object)this$requestedPublishingInterval).equals(other$requestedPublishingInterval)) {
            return false;
        }
        RequestHeader this$requestHeader = this.getRequestHeader();
        RequestHeader other$requestHeader = other.getRequestHeader();
        if (this$requestHeader == null ? other$requestHeader != null : !((Object)this$requestHeader).equals(other$requestHeader)) {
            return false;
        }
        UInteger this$subscriptionId = this.getSubscriptionId();
        UInteger other$subscriptionId = other.getSubscriptionId();
        if (this$subscriptionId == null ? other$subscriptionId != null : !((Object)this$subscriptionId).equals(other$subscriptionId)) {
            return false;
        }
        UInteger this$requestedLifetimeCount = this.getRequestedLifetimeCount();
        UInteger other$requestedLifetimeCount = other.getRequestedLifetimeCount();
        if (this$requestedLifetimeCount == null ? other$requestedLifetimeCount != null : !((Object)this$requestedLifetimeCount).equals(other$requestedLifetimeCount)) {
            return false;
        }
        UInteger this$requestedMaxKeepAliveCount = this.getRequestedMaxKeepAliveCount();
        UInteger other$requestedMaxKeepAliveCount = other.getRequestedMaxKeepAliveCount();
        if (this$requestedMaxKeepAliveCount == null ? other$requestedMaxKeepAliveCount != null : !((Object)this$requestedMaxKeepAliveCount).equals(other$requestedMaxKeepAliveCount)) {
            return false;
        }
        UInteger this$maxNotificationsPerPublish = this.getMaxNotificationsPerPublish();
        UInteger other$maxNotificationsPerPublish = other.getMaxNotificationsPerPublish();
        if (this$maxNotificationsPerPublish == null ? other$maxNotificationsPerPublish != null : !((Object)this$maxNotificationsPerPublish).equals(other$maxNotificationsPerPublish)) {
            return false;
        }
        UByte this$priority = this.getPriority();
        UByte other$priority = other.getPriority();
        return !(this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ModifySubscriptionRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $requestedPublishingInterval = this.getRequestedPublishingInterval();
        result = result * 59 + ($requestedPublishingInterval == null ? 43 : ((Object)$requestedPublishingInterval).hashCode());
        RequestHeader $requestHeader = this.getRequestHeader();
        result = result * 59 + ($requestHeader == null ? 43 : ((Object)$requestHeader).hashCode());
        UInteger $subscriptionId = this.getSubscriptionId();
        result = result * 59 + ($subscriptionId == null ? 43 : ((Object)$subscriptionId).hashCode());
        UInteger $requestedLifetimeCount = this.getRequestedLifetimeCount();
        result = result * 59 + ($requestedLifetimeCount == null ? 43 : ((Object)$requestedLifetimeCount).hashCode());
        UInteger $requestedMaxKeepAliveCount = this.getRequestedMaxKeepAliveCount();
        result = result * 59 + ($requestedMaxKeepAliveCount == null ? 43 : ((Object)$requestedMaxKeepAliveCount).hashCode());
        UInteger $maxNotificationsPerPublish = this.getMaxNotificationsPerPublish();
        result = result * 59 + ($maxNotificationsPerPublish == null ? 43 : ((Object)$maxNotificationsPerPublish).hashCode());
        UByte $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ModifySubscriptionRequest(requestHeader=" + this.getRequestHeader() + ", subscriptionId=" + this.getSubscriptionId() + ", requestedPublishingInterval=" + this.getRequestedPublishingInterval() + ", requestedLifetimeCount=" + this.getRequestedLifetimeCount() + ", requestedMaxKeepAliveCount=" + this.getRequestedMaxKeepAliveCount() + ", maxNotificationsPerPublish=" + this.getMaxNotificationsPerPublish() + ", priority=" + this.getPriority() + ")";
    }

    private static final class ModifySubscriptionRequestBuilderImpl
    extends ModifySubscriptionRequestBuilder<ModifySubscriptionRequest, ModifySubscriptionRequestBuilderImpl> {
        private ModifySubscriptionRequestBuilderImpl() {
        }

        @Override
        protected ModifySubscriptionRequestBuilderImpl self() {
            return this;
        }

        @Override
        public ModifySubscriptionRequest build() {
            return new ModifySubscriptionRequest(this);
        }
    }

    public static abstract class ModifySubscriptionRequestBuilder<C extends ModifySubscriptionRequest, B extends ModifySubscriptionRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RequestHeader requestHeader;
        private UInteger subscriptionId;
        private Double requestedPublishingInterval;
        private UInteger requestedLifetimeCount;
        private UInteger requestedMaxKeepAliveCount;
        private UInteger maxNotificationsPerPublish;
        private UByte priority;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            ModifySubscriptionRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(ModifySubscriptionRequest instance, ModifySubscriptionRequestBuilder<?, ?> b) {
            b.requestHeader(instance.requestHeader);
            b.subscriptionId(instance.subscriptionId);
            b.requestedPublishingInterval(instance.requestedPublishingInterval);
            b.requestedLifetimeCount(instance.requestedLifetimeCount);
            b.requestedMaxKeepAliveCount(instance.requestedMaxKeepAliveCount);
            b.maxNotificationsPerPublish(instance.maxNotificationsPerPublish);
            b.priority(instance.priority);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B requestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return (B)this.self();
        }

        public B subscriptionId(UInteger subscriptionId) {
            this.subscriptionId = subscriptionId;
            return (B)this.self();
        }

        public B requestedPublishingInterval(Double requestedPublishingInterval) {
            this.requestedPublishingInterval = requestedPublishingInterval;
            return (B)this.self();
        }

        public B requestedLifetimeCount(UInteger requestedLifetimeCount) {
            this.requestedLifetimeCount = requestedLifetimeCount;
            return (B)this.self();
        }

        public B requestedMaxKeepAliveCount(UInteger requestedMaxKeepAliveCount) {
            this.requestedMaxKeepAliveCount = requestedMaxKeepAliveCount;
            return (B)this.self();
        }

        public B maxNotificationsPerPublish(UInteger maxNotificationsPerPublish) {
            this.maxNotificationsPerPublish = maxNotificationsPerPublish;
            return (B)this.self();
        }

        public B priority(UByte priority) {
            this.priority = priority;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ModifySubscriptionRequest.ModifySubscriptionRequestBuilder(super=" + super.toString() + ", requestHeader=" + this.requestHeader + ", subscriptionId=" + this.subscriptionId + ", requestedPublishingInterval=" + this.requestedPublishingInterval + ", requestedLifetimeCount=" + this.requestedLifetimeCount + ", requestedMaxKeepAliveCount=" + this.requestedMaxKeepAliveCount + ", maxNotificationsPerPublish=" + this.maxNotificationsPerPublish + ", priority=" + this.priority + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<ModifySubscriptionRequest> {
        @Override
        public Class<ModifySubscriptionRequest> getType() {
            return ModifySubscriptionRequest.class;
        }

        @Override
        public ModifySubscriptionRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            UInteger subscriptionId = decoder.readUInt32("SubscriptionId");
            Double requestedPublishingInterval = decoder.readDouble("RequestedPublishingInterval");
            UInteger requestedLifetimeCount = decoder.readUInt32("RequestedLifetimeCount");
            UInteger requestedMaxKeepAliveCount = decoder.readUInt32("RequestedMaxKeepAliveCount");
            UInteger maxNotificationsPerPublish = decoder.readUInt32("MaxNotificationsPerPublish");
            UByte priority = decoder.readByte("Priority");
            return new ModifySubscriptionRequest(requestHeader, subscriptionId, requestedPublishingInterval, requestedLifetimeCount, requestedMaxKeepAliveCount, maxNotificationsPerPublish, priority);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, ModifySubscriptionRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeUInt32("SubscriptionId", value.getSubscriptionId());
            encoder.writeDouble("RequestedPublishingInterval", value.getRequestedPublishingInterval());
            encoder.writeUInt32("RequestedLifetimeCount", value.getRequestedLifetimeCount());
            encoder.writeUInt32("RequestedMaxKeepAliveCount", value.getRequestedMaxKeepAliveCount());
            encoder.writeUInt32("MaxNotificationsPerPublish", value.getMaxNotificationsPerPublish());
            encoder.writeByte("Priority", value.getPriority());
        }
    }
}

