/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.receiver.protocol.airgap;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.zip.CRC32;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.concurrent.WrappedRunnable;
import org.apache.iotdb.commons.pipe.config.PipeConfig;
import org.apache.iotdb.commons.pipe.connector.payload.airgap.AirGapELanguageConstant;
import org.apache.iotdb.commons.pipe.connector.payload.airgap.AirGapOneByteResponse;
import org.apache.iotdb.commons.pipe.connector.payload.airgap.AirGapPseudoTPipeTransferRequest;
import org.apache.iotdb.db.pipe.agent.PipeDataNodeAgent;
import org.apache.iotdb.db.pipe.receiver.protocol.thrift.IoTDBDataNodeReceiverAgent;
import org.apache.iotdb.db.protocol.session.ClientSession;
import org.apache.iotdb.db.protocol.session.SessionManager;
import org.apache.iotdb.pipe.api.exception.PipeConnectionException;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferReq;
import org.apache.iotdb.service.rpc.thrift.TPipeTransferResp;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IoTDBAirGapReceiver
extends WrappedRunnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoTDBAirGapReceiver.class);
    private final Socket socket;
    private final long receiverId;
    private final IoTDBDataNodeReceiverAgent agent;
    private boolean isELanguagePayload;

    public IoTDBAirGapReceiver(Socket socket, long receiverId) {
        this.socket = socket;
        this.receiverId = receiverId;
        this.agent = PipeDataNodeAgent.receiver().thrift();
    }

    public void runMayThrow() throws Throwable {
        this.socket.setSoTimeout(PipeConfig.getInstance().getPipeConnectorTransferTimeoutMs());
        this.socket.setKeepAlive(true);
        LOGGER.info("Pipe air gap receiver {} started. Socket: {}", (Object)this.receiverId, (Object)this.socket);
        SessionManager.getInstance().registerSession(new ClientSession(this.socket));
        try {
            while (!this.socket.isClosed()) {
                this.isELanguagePayload = false;
                this.receive();
            }
            LOGGER.info("Pipe air gap receiver {} closed because socket is closed. Socket: {}", (Object)this.receiverId, (Object)this.socket);
        }
        catch (Exception e) {
            LOGGER.warn("Pipe air gap receiver {} closed because of exception. Socket: {}", new Object[]{this.receiverId, this.socket, e});
            throw e;
        }
        finally {
            PipeDataNodeAgent.receiver().thrift().handleClientExit();
            this.socket.close();
        }
    }

    private void receive() throws IOException {
        BufferedInputStream inputStream = new BufferedInputStream(this.socket.getInputStream());
        try {
            byte[] data = this.readData(inputStream);
            if (!this.checkSum(data)) {
                LOGGER.warn("Pipe air gap receiver {} closed because of checksum failed. Socket: {}", (Object)this.receiverId, (Object)this.socket);
                try {
                    this.fail();
                }
                finally {
                    this.socket.close();
                }
                return;
            }
            ByteBuffer byteBuffer = ByteBuffer.wrap(data, 8, data.length - 8);
            AirGapPseudoTPipeTransferRequest req = (AirGapPseudoTPipeTransferRequest)new AirGapPseudoTPipeTransferRequest().setVersion(ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer)).setType(ReadWriteIOUtils.readShort((ByteBuffer)byteBuffer)).setBody(byteBuffer.slice());
            TPipeTransferResp resp = this.agent.receive((TPipeTransferReq)req);
            TSStatus status = resp.getStatus();
            if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                this.ok();
            } else if (status.getCode() == TSStatusCode.REDIRECTION_RECOMMEND.getStatusCode() || status.getCode() == TSStatusCode.PIPE_RECEIVER_IDEMPOTENT_CONFLICT_EXCEPTION.getStatusCode()) {
                LOGGER.info("Pipe air gap receiver {}: TSStatus {} is encountered at the air gap receiver, will ignore.", (Object)this.receiverId, (Object)resp.getStatus());
                this.ok();
            } else {
                LOGGER.warn("Pipe air gap receiver {}: Handle data failed, status: {}, req: {}", new Object[]{this.receiverId, resp.getStatus(), req});
                this.fail();
            }
        }
        catch (PipeConnectionException e) {
            LOGGER.info("Pipe air gap receiver {}: Socket {} closed when listening to data. Because: {}", new Object[]{this.receiverId, this.socket, e.getMessage()});
            this.socket.close();
        }
        catch (Exception e) {
            LOGGER.warn("Pipe air gap receiver {}: Exception during handling receiving. Socket: {}", new Object[]{this.receiverId, this.socket, e});
            this.fail();
        }
    }

    private void ok() throws IOException {
        OutputStream outputStream = this.socket.getOutputStream();
        outputStream.write(AirGapOneByteResponse.OK);
        outputStream.flush();
    }

    private void fail() throws IOException {
        OutputStream outputStream = this.socket.getOutputStream();
        outputStream.write(AirGapOneByteResponse.FAIL);
        outputStream.flush();
    }

    private boolean checkSum(byte[] bytes) {
        try {
            CRC32 crc32 = new CRC32();
            crc32.update(bytes, 8, bytes.length - 8);
            long expectedChecksum = BytesUtils.bytesToLong((byte[])BytesUtils.subBytes((byte[])bytes, (int)0, (int)8));
            long actualChecksum = crc32.getValue();
            if (expectedChecksum != actualChecksum) {
                LOGGER.warn("Pipe air gap receiver {}: checksum failed, expected: {}, actual: {}", new Object[]{this.receiverId, expectedChecksum, actualChecksum});
            }
            return expectedChecksum == actualChecksum;
        }
        catch (Exception e) {
            return false;
        }
    }

    private byte[] readData(InputStream inputStream) throws IOException {
        int length = this.readLength(inputStream);
        if (length <= 0) {
            return new byte[0];
        }
        byte[] resultBuffer = new byte[length];
        this.readTillFull(inputStream, resultBuffer);
        if (this.isELanguagePayload) {
            this.skipTillEnough(inputStream, AirGapELanguageConstant.E_LANGUAGE_SUFFIX.length);
        }
        return resultBuffer;
    }

    private int readLength(InputStream inputStream) throws IOException {
        byte[] doubleIntLengthBytes = new byte[8];
        this.readTillFull(inputStream, doubleIntLengthBytes);
        if (Arrays.equals(doubleIntLengthBytes, BytesUtils.subBytes((byte[])AirGapELanguageConstant.E_LANGUAGE_PREFIX, (int)0, (int)8))) {
            this.isELanguagePayload = true;
            this.skipTillEnough(inputStream, (long)AirGapELanguageConstant.E_LANGUAGE_PREFIX.length - 8L);
            return this.readLength(inputStream);
        }
        byte[] dataLengthBytes = BytesUtils.subBytes((byte[])doubleIntLengthBytes, (int)0, (int)4);
        return Arrays.equals(dataLengthBytes, BytesUtils.subBytes((byte[])doubleIntLengthBytes, (int)4, (int)4)) ? BytesUtils.bytesToInt((byte[])dataLengthBytes) : 0;
    }

    private void readTillFull(InputStream inputStream, byte[] readBuffer) throws IOException, PipeConnectionException {
        int readBytes;
        for (int alreadyReadBytes = 0; alreadyReadBytes < readBuffer.length; alreadyReadBytes += readBytes) {
            readBytes = inputStream.read(readBuffer, alreadyReadBytes, readBuffer.length - alreadyReadBytes);
            if (readBytes != -1) continue;
            throw new PipeConnectionException("Socket closed when executing readTillFull.");
        }
    }

    private void skipTillEnough(InputStream inputStream, long length) throws IOException, PipeConnectionException {
        long skippedBytes;
        for (long currentSkippedBytes = 0L; currentSkippedBytes < length; currentSkippedBytes += skippedBytes) {
            skippedBytes = inputStream.skip(length - currentSkippedBytes);
            if (skippedBytes != 0L) continue;
            throw new PipeConnectionException("Socket closed when executing skipTillEnough.");
        }
    }
}

