/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.function;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.db.queryengine.plan.relational.utils.TypeUtil;
import org.apache.tsfile.read.common.type.Type;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class BoundSignature {
    private final String functionName;
    private final Type returnType;
    private final List<Type> argumentTypes;

    public BoundSignature(String functionName, Type returnType, List<Type> argumentTypes) {
        this.functionName = Objects.requireNonNull(functionName, "functionName is null");
        this.returnType = Objects.requireNonNull(returnType, "returnType is null");
        this.argumentTypes = argumentTypes;
    }

    public String getName() {
        return this.functionName;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public Type getArgumentType(int index) {
        return this.argumentTypes.get(index);
    }

    public List<Type> getArgumentTypes() {
        return this.argumentTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BoundSignature that = (BoundSignature)o;
        return Objects.equals(this.functionName, that.functionName) && Objects.equals(this.returnType, that.returnType) && Objects.equals(this.argumentTypes, that.argumentTypes);
    }

    public int hashCode() {
        return Objects.hash(this.functionName, this.returnType, this.argumentTypes);
    }

    public String toString() {
        return this.functionName + this.argumentTypes.stream().map(Object::toString).collect(Collectors.joining(", ", "(", "):")) + this.returnType;
    }

    public void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((String)this.functionName, (ByteBuffer)byteBuffer);
        TypeUtil.serialize(this.returnType, byteBuffer);
        ReadWriteIOUtils.write((int)this.argumentTypes.size(), (ByteBuffer)byteBuffer);
        for (Type type : this.argumentTypes) {
            TypeUtil.serialize(type, byteBuffer);
        }
    }

    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((String)this.functionName, (OutputStream)stream);
        TypeUtil.serialize(this.returnType, stream);
        ReadWriteIOUtils.write((int)this.argumentTypes.size(), (OutputStream)stream);
        for (Type type : this.argumentTypes) {
            TypeUtil.serialize(type, stream);
        }
    }

    public static BoundSignature deserialize(ByteBuffer byteBuffer) {
        String functionName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        Type returnType = TypeUtil.deserialize(byteBuffer);
        int size = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        ArrayList<Type> argumentTypes = new ArrayList<Type>(size);
        while (size-- > 0) {
            argumentTypes.add(TypeUtil.deserialize(byteBuffer));
        }
        return new BoundSignature(functionName, returnType, argumentTypes);
    }
}

