/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation;

import com.google.common.base.Preconditions;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.AggregationMask;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.TableAccumulator;
import org.apache.iotdb.db.queryengine.execution.operator.source.relational.aggregation.Utils;
import org.apache.tsfile.block.column.Column;
import org.apache.tsfile.block.column.ColumnBuilder;
import org.apache.tsfile.enums.TSDataType;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.block.column.BinaryColumn;
import org.apache.tsfile.read.common.block.column.BinaryColumnBuilder;
import org.apache.tsfile.read.common.block.column.RunLengthEncodedColumn;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.BytesUtils;
import org.apache.tsfile.utils.RamUsageEstimator;
import org.apache.tsfile.utils.TsPrimitiveType;
import org.apache.tsfile.write.UnSupportedDataTypeException;

public class FirstAccumulator
implements TableAccumulator {
    private static final long INSTANCE_SIZE = RamUsageEstimator.shallowSizeOfInstance(FirstAccumulator.class);
    protected final TSDataType seriesDataType;
    protected TsPrimitiveType firstValue;
    protected long minTime = Long.MAX_VALUE;
    protected boolean initResult = false;

    public FirstAccumulator(TSDataType seriesDataType) {
        this.seriesDataType = seriesDataType;
        this.firstValue = TsPrimitiveType.getByType((TSDataType)seriesDataType);
    }

    @Override
    public long getEstimatedSize() {
        return INSTANCE_SIZE;
    }

    @Override
    public TableAccumulator copy() {
        return new FirstAccumulator(this.seriesDataType);
    }

    @Override
    public void addInput(Column[] arguments, AggregationMask mask) {
        switch (this.seriesDataType) {
            case INT32: 
            case DATE: {
                this.addIntInput(arguments[0], arguments[1], mask);
                return;
            }
            case INT64: 
            case TIMESTAMP: {
                this.addLongInput(arguments[0], arguments[1], mask);
                return;
            }
            case FLOAT: {
                this.addFloatInput(arguments[0], arguments[1], mask);
                return;
            }
            case DOUBLE: {
                this.addDoubleInput(arguments[0], arguments[1], mask);
                return;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                this.addBinaryInput(arguments[0], arguments[1], mask);
                return;
            }
            case BOOLEAN: {
                this.addBooleanInput(arguments[0], arguments[1], mask);
                return;
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in FIRST: %s", this.seriesDataType));
    }

    @Override
    public void addIntermediate(Column argument) {
        Preconditions.checkArgument((argument instanceof BinaryColumn || argument instanceof RunLengthEncodedColumn && ((RunLengthEncodedColumn)argument).getValue() instanceof BinaryColumn ? 1 : 0) != 0, (Object)"intermediate input and output of FIRST should be BinaryColumn");
        block8: for (int i = 0; i < argument.getPositionCount(); ++i) {
            if (argument.isNull(i)) continue;
            byte[] bytes = argument.getBinary(i).getValues();
            long time = BytesUtils.bytesToLongFromOffset((byte[])bytes, (int)8, (int)0);
            int offset = 8;
            switch (this.seriesDataType) {
                case INT32: 
                case DATE: {
                    int intVal = BytesUtils.bytesToInt((byte[])bytes, (int)offset);
                    this.updateIntFirstValue(intVal, time);
                    continue block8;
                }
                case INT64: 
                case TIMESTAMP: {
                    long longVal = BytesUtils.bytesToLongFromOffset((byte[])bytes, (int)8, (int)offset);
                    this.updateLongFirstValue(longVal, time);
                    continue block8;
                }
                case FLOAT: {
                    float floatVal = BytesUtils.bytesToFloat((byte[])bytes, (int)offset);
                    this.updateFloatFirstValue(floatVal, time);
                    continue block8;
                }
                case DOUBLE: {
                    double doubleVal = BytesUtils.bytesToDouble((byte[])bytes, (int)offset);
                    this.updateDoubleFirstValue(doubleVal, time);
                    continue block8;
                }
                case TEXT: 
                case STRING: 
                case BLOB: {
                    int length = BytesUtils.bytesToInt((byte[])bytes, (int)offset);
                    Binary binaryVal = new Binary(BytesUtils.subBytes((byte[])bytes, (int)(offset += 4), (int)length));
                    this.updateBinaryFirstValue(binaryVal, time);
                    continue block8;
                }
                case BOOLEAN: {
                    boolean boolVal = BytesUtils.bytesToBool((byte[])bytes, (int)offset);
                    this.updateBooleanFirstValue(boolVal, time);
                    continue block8;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Unsupported data type in FIRST Aggregation: %s", this.seriesDataType));
                }
            }
        }
    }

    @Override
    public void evaluateIntermediate(ColumnBuilder columnBuilder) {
        Preconditions.checkArgument((boolean)(columnBuilder instanceof BinaryColumnBuilder), (Object)"intermediate input and output of FIRST should be BinaryColumn");
        if (!this.initResult) {
            columnBuilder.appendNull();
        } else {
            columnBuilder.writeBinary(new Binary(Utils.serializeTimeValue(this.seriesDataType, this.minTime, this.firstValue)));
        }
    }

    @Override
    public void evaluateFinal(ColumnBuilder columnBuilder) {
        if (!this.initResult) {
            columnBuilder.appendNull();
        } else {
            switch (this.seriesDataType) {
                case INT32: 
                case DATE: {
                    columnBuilder.writeInt(this.firstValue.getInt());
                    break;
                }
                case INT64: 
                case TIMESTAMP: {
                    columnBuilder.writeLong(this.firstValue.getLong());
                    break;
                }
                case FLOAT: {
                    columnBuilder.writeFloat(this.firstValue.getFloat());
                    break;
                }
                case DOUBLE: {
                    columnBuilder.writeDouble(this.firstValue.getDouble());
                    break;
                }
                case TEXT: 
                case STRING: 
                case BLOB: {
                    columnBuilder.writeBinary(this.firstValue.getBinary());
                    break;
                }
                case BOOLEAN: {
                    columnBuilder.writeBoolean(this.firstValue.getBoolean());
                    break;
                }
                default: {
                    throw new UnSupportedDataTypeException(String.format("Unsupported data type in FIRST aggregation: %s", this.seriesDataType));
                }
            }
        }
    }

    @Override
    public boolean hasFinalResult() {
        return this.initResult;
    }

    @Override
    public void addStatistics(Statistics[] statistics) {
        if (statistics == null || statistics[0] == null) {
            return;
        }
        switch (this.seriesDataType) {
            case INT32: 
            case DATE: {
                this.updateIntFirstValue((Integer)statistics[0].getFirstValue(), statistics[0].getStartTime());
                break;
            }
            case INT64: 
            case TIMESTAMP: {
                this.updateLongFirstValue((Long)statistics[0].getFirstValue(), statistics[0].getStartTime());
                break;
            }
            case FLOAT: {
                this.updateFloatFirstValue(((Float)statistics[0].getFirstValue()).floatValue(), statistics[0].getStartTime());
                break;
            }
            case DOUBLE: {
                this.updateDoubleFirstValue((Double)statistics[0].getFirstValue(), statistics[0].getStartTime());
                break;
            }
            case TEXT: 
            case STRING: 
            case BLOB: {
                this.updateBinaryFirstValue((Binary)statistics[0].getFirstValue(), statistics[0].getStartTime());
                break;
            }
            case BOOLEAN: {
                this.updateBooleanFirstValue((Boolean)statistics[0].getFirstValue(), statistics[0].getStartTime());
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("Unsupported data type in FIRST Aggregation: %s", this.seriesDataType));
            }
        }
    }

    @Override
    public void reset() {
        this.initResult = false;
        this.minTime = Long.MAX_VALUE;
        this.firstValue.reset();
    }

    protected void addIntInput(Column valueColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (valueColumn.isNull(i)) continue;
                this.updateIntFirstValue(valueColumn.getInt(i), timeColumn.getLong(i));
                return;
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                this.updateIntFirstValue(valueColumn.getInt(position), timeColumn.getLong(position));
                return;
            }
        }
    }

    protected void updateIntFirstValue(int value, long curTime) {
        this.initResult = true;
        if (curTime < this.minTime) {
            this.minTime = curTime;
            this.firstValue.setInt(value);
        }
    }

    protected void addLongInput(Column valueColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (valueColumn.isNull(i)) continue;
                this.updateLongFirstValue(valueColumn.getLong(i), timeColumn.getLong(i));
                return;
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                this.updateLongFirstValue(valueColumn.getLong(position), timeColumn.getLong(position));
                return;
            }
        }
    }

    protected void updateLongFirstValue(long value, long curTime) {
        this.initResult = true;
        if (curTime < this.minTime) {
            this.minTime = curTime;
            this.firstValue.setLong(value);
        }
    }

    protected void addFloatInput(Column valueColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (valueColumn.isNull(i)) continue;
                this.updateFloatFirstValue(valueColumn.getFloat(i), timeColumn.getLong(i));
                return;
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                this.updateFloatFirstValue(valueColumn.getFloat(position), timeColumn.getLong(position));
                return;
            }
        }
    }

    protected void updateFloatFirstValue(float value, long curTime) {
        this.initResult = true;
        if (curTime < this.minTime) {
            this.minTime = curTime;
            this.firstValue.setFloat(value);
        }
    }

    protected void addDoubleInput(Column valueColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (valueColumn.isNull(i)) continue;
                this.updateDoubleFirstValue(valueColumn.getDouble(i), timeColumn.getLong(i));
                return;
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                this.updateDoubleFirstValue(valueColumn.getDouble(position), timeColumn.getLong(position));
                return;
            }
        }
    }

    protected void updateDoubleFirstValue(double value, long curTime) {
        this.initResult = true;
        if (curTime < this.minTime) {
            this.minTime = curTime;
            this.firstValue.setDouble(value);
        }
    }

    protected void addBinaryInput(Column valueColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (valueColumn.isNull(i)) continue;
                this.updateBinaryFirstValue(valueColumn.getBinary(i), timeColumn.getLong(i));
                return;
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                this.updateBinaryFirstValue(valueColumn.getBinary(position), timeColumn.getLong(position));
                return;
            }
        }
    }

    protected void updateBinaryFirstValue(Binary value, long curTime) {
        this.initResult = true;
        if (curTime < this.minTime) {
            this.minTime = curTime;
            this.firstValue.setBinary(value);
        }
    }

    protected void addBooleanInput(Column valueColumn, Column timeColumn, AggregationMask mask) {
        int positionCount = mask.getSelectedPositionCount();
        if (mask.isSelectAll()) {
            for (int i = 0; i < positionCount; ++i) {
                if (valueColumn.isNull(i)) continue;
                this.updateBooleanFirstValue(valueColumn.getBoolean(i), timeColumn.getLong(i));
                return;
            }
        } else {
            int[] selectedPositions = mask.getSelectedPositions();
            for (int i = 0; i < positionCount; ++i) {
                int position = selectedPositions[i];
                if (valueColumn.isNull(position)) continue;
                this.updateBooleanFirstValue(valueColumn.getBoolean(position), timeColumn.getLong(position));
                return;
            }
        }
    }

    protected void updateBooleanFirstValue(boolean value, long curTime) {
        this.initResult = true;
        if (curTime < this.minTime) {
            this.minTime = curTime;
            this.firstValue.setBoolean(value);
        }
    }
}

