/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Identifier;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.QualifiedName;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Statement;

public class DropIndex
extends Statement {
    private final QualifiedName tableName;
    private final Identifier indexName;

    public DropIndex(QualifiedName tableName, Identifier indexName) {
        super(null);
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.indexName = Objects.requireNonNull(indexName, "indexName is null");
    }

    public DropIndex(NodeLocation location, QualifiedName tableName, Identifier indexName) {
        super(Objects.requireNonNull(location, "location is null"));
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.indexName = Objects.requireNonNull(indexName, "indexName is null");
    }

    public QualifiedName getTableName() {
        return this.tableName;
    }

    public Identifier getIndexName() {
        return this.indexName;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDropIndex(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DropIndex dropIndex = (DropIndex)o;
        return Objects.equals(this.tableName, dropIndex.tableName) && Objects.equals(this.indexName, dropIndex.indexName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tableName, this.indexName);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("tableName", (Object)this.tableName).add("indexName", (Object)this.indexName).toString();
    }
}

