/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.utils.matching.pattern;

import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Captures;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Match;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Pattern;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.PatternVisitor;

public class TypeOfPattern<T>
extends Pattern<T> {
    private final Class<T> expectedClass;

    public TypeOfPattern(Class<T> expectedClass) {
        this(expectedClass, Optional.empty());
    }

    public TypeOfPattern(Class<T> expectedClass, Optional<Pattern<?>> previous) {
        super(previous);
        this.expectedClass = Objects.requireNonNull(expectedClass, "expectedClass is null");
    }

    public Class<T> expectedClass() {
        return this.expectedClass;
    }

    @Override
    public <C> Stream<Match> accept(Object object, Captures captures, C context) {
        if (this.expectedClass.isInstance(object)) {
            return Stream.of(Match.of(captures));
        }
        return Stream.of(new Match[0]);
    }

    @Override
    public void accept(PatternVisitor patternVisitor) {
        patternVisitor.visitTypeOf(this);
    }
}

