/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.imap.message.request;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.List;
import org.apache.james.imap.api.ImapCommand;
import org.apache.james.imap.api.Tag;
import org.apache.james.imap.api.message.IdRange;
import org.apache.james.imap.message.request.AbstractImapRequest;

public abstract class AbstractMessageRangeRequest
extends AbstractImapRequest {
    private final IdRange[] idSet;
    private final String mailboxName;
    private final boolean useUids;

    public AbstractMessageRangeRequest(ImapCommand command, IdRange[] idSet, String mailboxName, boolean useUids, Tag tag) {
        super(tag, command);
        this.idSet = idSet;
        this.mailboxName = mailboxName;
        this.useUids = useUids;
    }

    public final IdRange[] getIdSet() {
        return this.idSet;
    }

    public final String getMailboxName() {
        return this.mailboxName;
    }

    public final boolean isUseUids() {
        return this.useUids;
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractMessageRangeRequest that = (AbstractMessageRangeRequest)o;
        return this.equals(this.idSet, that.idSet) && Objects.equal((Object)this.mailboxName, (Object)that.mailboxName) && Objects.equal((Object)this.useUids, (Object)that.useUids);
    }

    private boolean equals(IdRange[] idSet1, IdRange[] idSet2) {
        List<IdRange> idRanges1 = Arrays.asList(idSet1);
        List<IdRange> idRanges2 = Arrays.asList(idSet2);
        return Objects.equal(idRanges1, idRanges2);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{Arrays.hashCode(this.idSet), this.mailboxName, this.useUids});
    }
}

