/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.string;
import jakarta.inject.Inject;
import java.io.Serializable;
import java.time.Clock;
import org.apache.james.jmap.api.model.PushSubscription;
import org.apache.james.jmap.api.model.PushSubscriptionExpiredTime;
import org.apache.james.jmap.api.model.PushSubscriptionId$;
import org.apache.james.jmap.api.pushsubscription.PushSubscriptionHelpers;
import org.apache.james.jmap.api.pushsubscription.PushSubscriptionRepository;
import org.apache.james.jmap.core.CapabilityIdentifier$;
import org.apache.james.jmap.core.Ids;
import org.apache.james.jmap.core.Invocation;
import org.apache.james.jmap.core.JmapRfc8621Configuration;
import org.apache.james.jmap.core.Properties;
import org.apache.james.jmap.core.PushSubscriptionDTO;
import org.apache.james.jmap.core.PushSubscriptionDTO$;
import org.apache.james.jmap.core.PushSubscriptionGetRequest;
import org.apache.james.jmap.core.PushSubscriptionGetResponse;
import org.apache.james.jmap.core.SessionTranslator;
import org.apache.james.jmap.core.UnparsedPushSubscriptionId;
import org.apache.james.jmap.core.UnparsedPushSubscriptionId$;
import org.apache.james.jmap.json.PushSubscriptionSerializer;
import org.apache.james.jmap.method.InvocationWithContext;
import org.apache.james.jmap.method.Method;
import org.apache.james.jmap.method.MethodWithoutAccountId;
import org.apache.james.jmap.method.PushSubscriptionGetResults;
import org.apache.james.jmap.method.package$;
import org.apache.james.jmap.routes.SessionSupplier;
import org.apache.james.lifecycle.api.Startable;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.metrics.api.MetricFactory;
import org.reactivestreams.Publisher;
import play.api.libs.json.JsObject;
import play.api.libs.json.JsValue;
import play.api.libs.json.Reads;
import play.api.libs.json.Reads$;
import reactor.core.scala.publisher.SFlux;
import reactor.core.scala.publisher.SFlux$;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnce;
import scala.collection.Set;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\t\u0005a\u0001B\r\u001b\u0001\u0015B\u0001B\u0010\u0001\u0003\u0002\u0003\u0006Ia\u0010\u0005\t\u000b\u0002\u0011)\u0019!C\u0001\r\"A!\n\u0001B\u0001B\u0003%q\t\u0003\u0005L\u0001\t\u0015\r\u0011\"\u0001M\u0011!!\u0006A!A!\u0002\u0013i\u0005\u0002C+\u0001\u0005\u000b\u0007I\u0011\u0001,\t\u0011y\u0003!\u0011!Q\u0001\n]C\u0001b\u0018\u0001\u0003\u0006\u0004%\t\u0001\u0019\u0005\tO\u0002\u0011\t\u0011)A\u0005C\"A\u0001\u000e\u0001BC\u0002\u0013\u0005\u0011\u000e\u0003\u0005n\u0001\t\u0005\t\u0015!\u0003k\u0011!q\u0007A!b\u0001\n\u0003y\u0007\u0002\u0003=\u0001\u0005\u0003\u0005\u000b\u0011\u00029\t\u000be\u0004A\u0011\u0001>\t\u0013\u0005e\u0001A1A\u0005B\u0005m\u0001\u0002CA\u0016\u0001\u0001\u0006I!!\b\t\u0013\u00055\u0002A1A\u0005B\u0005=\u0002\u0002CA5\u0001\u0001\u0006I!!\r\t\u000f\u0005-\u0004\u0001\"\u0011\u0002n!9\u0011\u0011\u0013\u0001\u0005B\u0005M\u0005bBAc\u0001\u0011%\u0011q\u0019\u0005\b\u0003+\u0004A\u0011BAl\u0011\u001d\tY\u000e\u0001C\u0005\u0003;Dq!!2\u0001\t\u0013\t\u0019PA\rQkND7+\u001e2tGJL\u0007\u000f^5p]\u001e+G/T3uQ>$'BA\u000e\u001d\u0003\u0019iW\r\u001e5pI*\u0011QDH\u0001\u0005U6\f\u0007O\u0003\u0002 A\u0005)!.Y7fg*\u0011\u0011EI\u0001\u0007CB\f7\r[3\u000b\u0003\r\n1a\u001c:h\u0007\u0001\u0019B\u0001\u0001\u0014-mA\u0011qEK\u0007\u0002Q)\t\u0011&A\u0003tG\u0006d\u0017-\u0003\u0002,Q\t1\u0011I\\=SK\u001a\u00042!\f\u00181\u001b\u0005Q\u0012BA\u0018\u001b\u0005YiU\r\u001e5pI^KG\u000f[8vi\u0006\u001b7m\\;oi&#\u0007CA\u00195\u001b\u0005\u0011$BA\u001a\u001d\u0003\u0011\u0019wN]3\n\u0005U\u0012$A\u0007)vg\"\u001cVOY:de&\u0004H/[8o\u000f\u0016$(+Z9vKN$\bCA\u001c=\u001b\u0005A$BA\u001d;\u0003\r\t\u0007/\u001b\u0006\u0003wy\t\u0011\u0002\\5gK\u000eL8\r\\3\n\u0005uB$!C*uCJ$\u0018M\u00197f\u0003i\u0001Xo\u001d5Tk\n\u001c8M]5qi&|gnU3sS\u0006d\u0017N_3s!\t\u00015)D\u0001B\u0015\t\u0011E$\u0001\u0003kg>t\u0017B\u0001#B\u0005i\u0001Vo\u001d5Tk\n\u001c8M]5qi&|gnU3sS\u0006d\u0017N_3s\u00035\u0019wN\u001c4jOV\u0014\u0018\r^5p]V\tq\t\u0005\u00022\u0011&\u0011\u0011J\r\u0002\u0019\u00156\f\u0007O\u00154dqY\u0012\u0014gQ8oM&<WO]1uS>t\u0017AD2p]\u001aLw-\u001e:bi&|g\u000eI\u0001\u001baV\u001c\bnU;cg\u000e\u0014\u0018\u000e\u001d;j_:\u0014V\r]8tSR|'/_\u000b\u0002\u001bB\u0011aJU\u0007\u0002\u001f*\u0011\u0001+U\u0001\u0011aV\u001c\bn];cg\u000e\u0014\u0018\u000e\u001d;j_:T!!\u000f\u000f\n\u0005M{%A\u0007)vg\"\u001cVOY:de&\u0004H/[8o%\u0016\u0004xn]5u_JL\u0018a\u00079vg\"\u001cVOY:de&\u0004H/[8o%\u0016\u0004xn]5u_JL\b%A\u0007nKR\u0014\u0018n\u0019$bGR|'/_\u000b\u0002/B\u0011\u0001\fX\u0007\u00023*\u0011\u0011H\u0017\u0006\u00037z\tq!\\3ue&\u001c7/\u0003\u0002^3\niQ*\u001a;sS\u000e4\u0015m\u0019;pef\fa\"\\3ue&\u001cg)Y2u_JL\b%A\btKN\u001c\u0018n\u001c8TkB\u0004H.[3s+\u0005\t\u0007C\u00012f\u001b\u0005\u0019'B\u00013\u001d\u0003\u0019\u0011x.\u001e;fg&\u0011am\u0019\u0002\u0010'\u0016\u001c8/[8o'V\u0004\b\u000f\\5fe\u0006\u00012/Z:tS>t7+\u001e9qY&,'\u000fI\u0001\u0012g\u0016\u001c8/[8o)J\fgn\u001d7bi>\u0014X#\u00016\u0011\u0005EZ\u0017B\u000173\u0005E\u0019Vm]:j_:$&/\u00198tY\u0006$xN]\u0001\u0013g\u0016\u001c8/[8o)J\fgn\u001d7bi>\u0014\b%A\u0003dY>\u001c7.F\u0001q!\t\th/D\u0001s\u0015\t\u0019H/\u0001\u0003uS6,'\"A;\u0002\t)\fg/Y\u0005\u0003oJ\u0014Qa\u00117pG.\faa\u00197pG.\u0004\u0013A\u0002\u001fj]&$h\bF\u0006|yvtx0!\u0001\u0002\u0004\u0005\u0015\u0001CA\u0017\u0001\u0011\u0015qd\u00021\u0001@\u0011\u0015)e\u00021\u0001H\u0011\u0015Ye\u00021\u0001N\u0011\u0015)f\u00021\u0001X\u0011\u0015yf\u00021\u0001b\u0011\u0015Ag\u00021\u0001k\u0011\u0015qg\u00021\u0001qQ\rq\u0011\u0011\u0002\t\u0005\u0003\u0017\t)\"\u0004\u0002\u0002\u000e)!\u0011qBA\t\u0003\u0019IgN[3di*\u0011\u00111C\u0001\bU\u0006\\\u0017M\u001d;b\u0013\u0011\t9\"!\u0004\u0003\r%s'.Z2u\u0003)iW\r\u001e5pI:\u000bW.Z\u000b\u0003\u0003;\u0001B!a\b\u0002&9\u0019\u0011'!\t\n\u0007\u0005\r\"'\u0001\u0006J]Z|7-\u0019;j_:LA!a\n\u0002*\tQQ*\u001a;i_\u0012t\u0015-\\3\u000b\u0007\u0005\r\"'A\u0006nKRDw\u000e\u001a(b[\u0016\u0004\u0013\u0001\u0006:fcVL'/\u001a3DCB\f'-\u001b7ji&,7/\u0006\u0002\u00022A1\u00111GA!\u0003\u000frA!!\u000e\u0002>A\u0019\u0011q\u0007\u0015\u000e\u0005\u0005e\"bAA\u001eI\u00051AH]8pizJ1!a\u0010)\u0003\u0019\u0001&/\u001a3fM&!\u00111IA#\u0005\r\u0019V\r\u001e\u0006\u0004\u0003\u007fA\u0003\u0003BA%\u0003GrA!a\u0013\u0002`9!\u0011QJA/\u001d\u0011\ty%a\u0017\u000f\t\u0005E\u0013\u0011\f\b\u0005\u0003'\n9F\u0004\u0003\u00028\u0005U\u0013\"A\u0012\n\u0005\u0005\u0012\u0013BA\u0010!\u0013\tib$\u0003\u000249%\u0019\u0011\u0011\r\u001a\u0002)\r\u000b\u0007/\u00192jY&$\u00180\u00133f]RLg-[3s\u0013\u0011\t)'a\u001a\u0003)\r\u000b\u0007/\u00192jY&$\u00180\u00133f]RLg-[3s\u0015\r\t\tGM\u0001\u0016e\u0016\fX/\u001b:fI\u000e\u000b\u0007/\u00192jY&$\u0018.Z:!\u0003)9W\r\u001e*fcV,7\u000f\u001e\u000b\u0005\u0003_\n9\tE\u0004\u0002r\u0005m\u0014\u0011\u0011\u0019\u000f\t\u0005M\u0014q\u000f\b\u0005\u0003o\t)(C\u0001*\u0013\r\tI\bK\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\ti(a \u0003\r\u0015KG\u000f[3s\u0015\r\tI\b\u000b\t\u0005\u0003c\n\u0019)\u0003\u0003\u0002\u0006\u0006}$!C#yG\u0016\u0004H/[8o\u0011\u001d\tIi\u0005a\u0001\u0003\u0017\u000b!\"\u001b8w_\u000e\fG/[8o!\r\t\u0014QR\u0005\u0004\u0003\u001f\u0013$AC%om>\u001c\u0017\r^5p]\u0006IAm\u001c)s_\u000e,7o\u001d\u000b\t\u0003+\u000by+!-\u0002BB1\u0011qSAS\u0003Sk!!!'\u000b\t\u0005m\u0015QT\u0001\naV\u0014G.[:iKJT1!KAP\u0015\r\u0019\u0014\u0011\u0015\u0006\u0003\u0003G\u000bqA]3bGR|'/\u0003\u0003\u0002(\u0006e%!B*N_:|\u0007cA\u0017\u0002,&\u0019\u0011Q\u0016\u000e\u0003+%sgo\\2bi&|gnV5uQ\u000e{g\u000e^3yi\"9\u0011\u0011\u0012\u000bA\u0002\u0005%\u0006bBAZ)\u0001\u0007\u0011QW\u0001\bg\u0016\u001c8/[8o!\u0011\t9,!0\u000e\u0005\u0005e&bAA^=\u00059Q.Y5mE>D\u0018\u0002BA`\u0003s\u0013a\"T1jY\n|\u0007pU3tg&|g\u000e\u0003\u0004\u0002DR\u0001\r\u0001M\u0001\be\u0016\fX/Z:u\u0003=\u0011X\r\u001e:jKZ,'+Z2pe\u0012\u001cHCBAe\u0003#\f\u0019\u000e\u0005\u0004\u0002\u0018\u0006\u0015\u00161\u001a\t\u0004[\u00055\u0017bAAh5\tQ\u0002+^:i'V\u00147o\u0019:jaRLwN\\$fiJ+7/\u001e7ug\"1\u00111Y\u000bA\u0002ABq!a-\u0016\u0001\u0004\t),\u0001\nsKR\u0014\u0018.\u001a<f\u00032d'+Z2pe\u0012\u001cH\u0003BAe\u00033Dq!a-\u0017\u0001\u0004\t),\u0001\u0011dY\u0016\fg.\u0012=qSJ,GmU;cg\u000e\u0014\u0018\u000e\u001d;j_:LeMT3fI\u0016$GCBAp\u0003[\fy\u000f\u0005\u0004\u0002\u0018\u0006\u0015\u0016\u0011\u001d\t\u0005\u0003G\fI/\u0004\u0002\u0002f*\u0019\u0011q])\u0002\u000b5|G-\u001a7\n\t\u0005-\u0018Q\u001d\u0002\u0011!V\u001c\bnU;cg\u000e\u0014\u0018\u000e\u001d;j_:Dq!a-\u0018\u0001\u0004\t)\fC\u0004\u0002r^\u0001\r!!9\u0002\u0019M,(m]2sSB$\u0018n\u001c8\u0015\r\u0005%\u0017Q_A\u0000\u0011\u001d\t9\u0010\u0007a\u0001\u0003s\f1\"\u001e8qCJ\u001cX\rZ%egB\u0019\u0011'a?\n\u0007\u0005u(GA\u0002JINDq!a-\u0019\u0001\u0004\t)\f")
public class PushSubscriptionGetMethod
implements MethodWithoutAccountId<PushSubscriptionGetRequest>,
Startable {
    private final PushSubscriptionSerializer pushSubscriptionSerializer;
    private final JmapRfc8621Configuration configuration;
    private final PushSubscriptionRepository pushSubscriptionRepository;
    private final MetricFactory metricFactory;
    private final SessionSupplier sessionSupplier;
    private final SessionTranslator sessionTranslator;
    private final Clock clock;
    private final Invocation.MethodName methodName;
    private final scala.collection.immutable.Set<Refined<String, string.Uri>> requiredCapabilities;
    private String JMAP_RFC8621_PREFIX;

    @Override
    public Publisher<InvocationWithContext> process(scala.collection.immutable.Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession) {
        return MethodWithoutAccountId.process$(this, capabilities, invocation, mailboxSession);
    }

    @Override
    public String JMAP_RFC8621_PREFIX() {
        return this.JMAP_RFC8621_PREFIX;
    }

    @Override
    public void org$apache$james$jmap$method$Method$_setter_$JMAP_RFC8621_PREFIX_$eq(String x$1) {
        this.JMAP_RFC8621_PREFIX = x$1;
    }

    public JmapRfc8621Configuration configuration() {
        return this.configuration;
    }

    public PushSubscriptionRepository pushSubscriptionRepository() {
        return this.pushSubscriptionRepository;
    }

    @Override
    public MetricFactory metricFactory() {
        return this.metricFactory;
    }

    @Override
    public SessionSupplier sessionSupplier() {
        return this.sessionSupplier;
    }

    public SessionTranslator sessionTranslator() {
        return this.sessionTranslator;
    }

    public Clock clock() {
        return this.clock;
    }

    @Override
    public Invocation.MethodName methodName() {
        return this.methodName;
    }

    @Override
    public scala.collection.immutable.Set<Refined<String, string.Uri>> requiredCapabilities() {
        return this.requiredCapabilities;
    }

    @Override
    public Either<Exception, PushSubscriptionGetRequest> getRequest(Invocation invocation) {
        return package$.MODULE$.AsEitherRequest(this.pushSubscriptionSerializer.deserializePushSubscriptionGetRequest((JsValue)invocation.arguments())).asEitherRequest().flatMap((Function1 & Serializable)request -> request.validate(this.configuration()).map((Function1 & Serializable)x$3 -> request));
    }

    public SMono<InvocationWithContext> doProcess(InvocationWithContext invocation, MailboxSession session, PushSubscriptionGetRequest request) {
        return (SMono)request.validateProperties().fold((Function1 & Serializable)e -> SMono$.MODULE$.error((Throwable)e), (Function1 & Serializable)properties -> this.retrieveRecords(request, session).map((Function1 & Serializable)x$4 -> x$4.asResponse()).map((Function1 & Serializable)response -> new Invocation(this.methodName(), (JsObject)$this.pushSubscriptionSerializer.serialize((PushSubscriptionGetResponse)response, (Properties)properties).as((Reads)Reads$.MODULE$.JsObjectReads()), invocation.invocation().methodCallId())).map((Function1 & Serializable)invocationResult -> new InvocationWithContext((Invocation)invocationResult, invocation.processingContext())));
    }

    private SMono<PushSubscriptionGetResults> retrieveRecords(PushSubscriptionGetRequest request, MailboxSession session) {
        return (SMono)request.ids().map((Function1 & Serializable)x$5 -> this.retrieveRecords((Ids)x$5, session)).getOrElse((Function0 & Serializable)() -> this.retrieveAllRecords(session));
    }

    private SMono<PushSubscriptionGetResults> retrieveAllRecords(MailboxSession session) {
        SFlux qual$1 = SFlux$.MODULE$.apply(this.pushSubscriptionRepository().list(session.getUser()));
        Function1 & Serializable x$1 = (Function1 & Serializable)x$6 -> this.cleanExpiredSubscriptionIfNeeded(session, (PushSubscription)x$6);
        int x$2 = qual$1.flatMap$default$2();
        int x$3 = qual$1.flatMap$default$3();
        boolean x$4 = qual$1.flatMap$default$4();
        return qual$1.flatMap((Function1)x$1, x$2, x$3, x$4).map((Function1 & Serializable)pushSubscription -> PushSubscriptionDTO$.MODULE$.from((PushSubscription)pushSubscription)).collectSeq().map((Function1 & Serializable)dtos -> new PushSubscriptionGetResults((Seq<PushSubscriptionDTO>)dtos, (scala.collection.immutable.Set<UnparsedPushSubscriptionId>)((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Nil$.MODULE$))));
    }

    private SMono<PushSubscription> cleanExpiredSubscriptionIfNeeded(MailboxSession session, PushSubscription subscription) {
        if (PushSubscriptionHelpers.isInThePast((PushSubscriptionExpiredTime)subscription.expires(), (Clock)this.clock())) {
            return SMono$.MODULE$.apply(this.pushSubscriptionRepository().revoke(session.getUser(), subscription.id())).then(SMono$.MODULE$.empty());
        }
        return SMono$.MODULE$.fromCallable(() -> subscription);
    }

    private SMono<PushSubscriptionGetResults> retrieveRecords(Ids unparsedIds, MailboxSession session) {
        scala.collection.immutable.Set ids = unparsedIds.value().flatMap((Function1 & Serializable)unparsedId -> PushSubscriptionId$.MODULE$.parse(unparsedId.serialise()).toOption()).toSet();
        SFlux qual$1 = SFlux$.MODULE$.apply(this.pushSubscriptionRepository().get(session.getUser(), CollectionConverters$.MODULE$.SetHasAsJava((Set)ids).asJava()));
        Function1 & Serializable x$1 = (Function1 & Serializable)x$7 -> this.cleanExpiredSubscriptionIfNeeded(session, (PushSubscription)x$7);
        int x$2 = qual$1.flatMap$default$2();
        int x$3 = qual$1.flatMap$default$3();
        boolean x$4 = qual$1.flatMap$default$4();
        return qual$1.flatMap((Function1)x$1, x$2, x$3, x$4).map((Function1 & Serializable)pushSubscription -> PushSubscriptionDTO$.MODULE$.from((PushSubscription)pushSubscription)).collectSeq().map((Function1 & Serializable)dtos -> new PushSubscriptionGetResults((Seq<PushSubscriptionDTO>)dtos, (scala.collection.immutable.Set<UnparsedPushSubscriptionId>)((scala.collection.immutable.Set)unparsedIds.value().toSet().$minus$minus((IterableOnce)dtos.map((Function1 & Serializable)dto -> UnparsedPushSubscriptionId$.MODULE$.of(dto.id()))))));
    }

    @Inject
    public PushSubscriptionGetMethod(PushSubscriptionSerializer pushSubscriptionSerializer, JmapRfc8621Configuration configuration, PushSubscriptionRepository pushSubscriptionRepository, MetricFactory metricFactory, SessionSupplier sessionSupplier, SessionTranslator sessionTranslator, Clock clock) {
        this.pushSubscriptionSerializer = pushSubscriptionSerializer;
        this.configuration = configuration;
        this.pushSubscriptionRepository = pushSubscriptionRepository;
        this.metricFactory = metricFactory;
        this.sessionSupplier = sessionSupplier;
        this.sessionTranslator = sessionTranslator;
        this.clock = clock;
        Method.$init$(this);
        MethodWithoutAccountId.$init$(this);
        this.methodName = new Invocation.MethodName((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"PushSubscription/get")).value());
        this.requiredCapabilities = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)CapabilityIdentifier$.MODULE$.JMAP_CORE())}));
        Statics.releaseFence();
    }
}

