/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.generator.core.processor.annotation;

import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.swagger.SwaggerUtils;
import org.apache.servicecomb.swagger.generator.MethodAnnotationProcessor;
import org.apache.servicecomb.swagger.generator.OperationGenerator;
import org.apache.servicecomb.swagger.generator.SwaggerGenerator;
import org.apache.servicecomb.swagger.generator.core.processor.annotation.AnnotationUtils;
import org.springframework.util.CollectionUtils;

public class ApiResponsesMethodProcessor
implements MethodAnnotationProcessor<ApiResponses> {
    @Override
    public Type getProcessType() {
        return ApiResponses.class;
    }

    @Override
    public void process(SwaggerGenerator swaggerGenerator, OperationGenerator operationGenerator, ApiResponses apiResponses) {
        ArrayList<String> produces = new ArrayList<String>();
        for (ApiResponse apiResponse : apiResponses.value()) {
            if (StringUtils.isEmpty((CharSequence)apiResponse.responseCode()) || "default".equals(apiResponse.responseCode())) {
                throw new IllegalArgumentException("@ApiResponse status code must be defined.");
            }
            Class type = null;
            for (Content content : apiResponse.content()) {
                if (StringUtils.isNotEmpty((CharSequence)content.mediaType())) {
                    produces.add(content.mediaType());
                }
                if (content.schema() == null || content.schema().implementation() == Void.class) continue;
                type = content.schema().implementation();
            }
            operationGenerator.getOperationGeneratorContext().updateResponse(apiResponse.responseCode(), type == null ? null : SwaggerUtils.resolveTypeSchemas(swaggerGenerator.getOpenAPI(), type));
            if (StringUtils.isNotEmpty((CharSequence)apiResponse.description())) {
                operationGenerator.getOperationGeneratorContext().updateResponseDescription(apiResponse.responseCode(), apiResponse.description());
            }
            for (Content content : apiResponse.headers()) {
                if (content.schema() == null || content.schema().implementation() == Void.class) {
                    throw new IllegalArgumentException("@ApiResponse header schema implementation must be defined.");
                }
                if (StringUtils.isEmpty((CharSequence)content.name())) {
                    throw new IllegalArgumentException("@ApiResponse header name must be defined.");
                }
                operationGenerator.getOperationGeneratorContext().updateResponseHeader(apiResponse.responseCode(), content.name(), AnnotationUtils.schemaModel(swaggerGenerator.getOpenAPI(), content.schema()));
            }
        }
        if (!CollectionUtils.isEmpty(produces)) {
            operationGenerator.getOperationGeneratorContext().updateProduces(produces);
        }
    }
}

