/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.qps;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.eventbus.Subscribe;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.servicecomb.config.ConfigurationChangedEvent;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;
import org.apache.servicecomb.foundation.common.event.EventManager;
import org.apache.servicecomb.foundation.common.exceptions.ServiceCombException;
import org.apache.servicecomb.foundation.common.utils.SPIServiceUtils;
import org.apache.servicecomb.qps.QpsStrategy;
import org.apache.servicecomb.qps.strategy.AbstractQpsStrategy;
import org.apache.servicecomb.qps.strategy.IStrategyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.env.Environment;

public final class QpsControllerManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(QpsControllerManager.class);
    public static final String SEPARATOR = ".";
    private final Map<String, AbstractQpsStrategy> configQpsControllerMap = new ConcurrentHashMapEx();
    private final Map<String, AbstractQpsStrategy> qualifiedNameControllerMap = new ConcurrentHashMapEx();
    private AbstractQpsStrategy globalQpsStrategy;
    private final String limitKeyPrefix;
    private final String bucketKeyPrefix;
    private final String globalLimitKey;
    private final String globalBucketKey;
    private final Environment environment;

    public QpsControllerManager(boolean isProvider, Environment environment) {
        this.environment = environment;
        if (isProvider) {
            this.limitKeyPrefix = "servicecomb.flowcontrol.Provider.qps.limit.";
            this.bucketKeyPrefix = "servicecomb.flowcontrol.Provider.qps.bucket.";
            this.globalLimitKey = "servicecomb.flowcontrol.Provider.qps.global.limit";
            this.globalBucketKey = "servicecomb.flowcontrol.Provider.qps.global.bucket";
        } else {
            this.limitKeyPrefix = "servicecomb.flowcontrol.Consumer.qps.limit.";
            this.bucketKeyPrefix = "servicecomb.flowcontrol.Consumer.qps.bucket.";
            this.globalLimitKey = "servicecomb.flowcontrol.Consumer.qps.global.limit";
            this.globalBucketKey = "servicecomb.flowcontrol.Consumer.qps.global.bucket";
        }
        this.initGlobalQpsController();
        EventManager.register((Object)this);
    }

    @Subscribe
    public void onConfigurationChangedEvent(ConfigurationChangedEvent event) {
        for (String changed : event.getChanged()) {
            if (!changed.startsWith("servicecomb.flowcontrol.")) continue;
            this.configQpsControllerMap.clear();
            this.qualifiedNameControllerMap.clear();
            this.initGlobalQpsController();
            break;
        }
    }

    @VisibleForTesting
    public Map<String, AbstractQpsStrategy> getQualifiedNameControllerMap() {
        return this.qualifiedNameControllerMap;
    }

    public QpsStrategy getOrCreate(String microserviceName, Invocation invocation) {
        String name = this.validatedName(microserviceName);
        return this.qualifiedNameControllerMap.computeIfAbsent(name + SEPARATOR + invocation.getOperationMeta().getSchemaQualifiedName(), key -> this.create((String)key, name, invocation));
    }

    private String validatedName(String microserviceName) {
        String name = microserviceName;
        if (StringUtils.isEmpty((CharSequence)microserviceName)) {
            name = "ANY";
        }
        return name;
    }

    @VisibleForTesting
    AbstractQpsStrategy create(String qualifiedNameKey, String microserviceName, Invocation invocation) {
        this.createForService(qualifiedNameKey, microserviceName, invocation);
        String qualifiedAnyServiceName = "ANY" + qualifiedNameKey.substring(microserviceName.length());
        this.createForService(qualifiedAnyServiceName, "ANY", invocation);
        AbstractQpsStrategy strategy = this.searchQpsController(qualifiedNameKey);
        if (strategy == null) {
            strategy = this.searchQpsController(qualifiedAnyServiceName);
        }
        if (strategy == null) {
            return this.globalQpsStrategy;
        }
        return strategy;
    }

    private void createForService(String qualifiedNameKey, String microserviceName, Invocation invocation) {
        this.createQpsControllerIfNotExist(microserviceName);
        this.createQpsControllerIfNotExist(qualifiedNameKey.substring(0, microserviceName.length() + invocation.getSchemaId().length() + 1));
        this.createQpsControllerIfNotExist(qualifiedNameKey);
    }

    private AbstractQpsStrategy searchQpsController(String qualifiedNameKey) {
        AbstractQpsStrategy qpsStrategy = this.configQpsControllerMap.get(qualifiedNameKey);
        if (this.isValidQpsController(qpsStrategy)) {
            return qpsStrategy;
        }
        int index = qualifiedNameKey.lastIndexOf(SEPARATOR);
        while (index > 0) {
            qpsStrategy = this.configQpsControllerMap.get(qualifiedNameKey.substring(0, index));
            if (this.isValidQpsController(qpsStrategy)) {
                return qpsStrategy;
            }
            index = qualifiedNameKey.lastIndexOf(SEPARATOR, index - 1);
        }
        if (this.isValidQpsController(qpsStrategy)) {
            return qpsStrategy;
        }
        return null;
    }

    private boolean isValidQpsController(AbstractQpsStrategy qpsStrategy) {
        return null != qpsStrategy && null != qpsStrategy.getQpsLimit();
    }

    private void createQpsControllerIfNotExist(String configKey) {
        if (this.configQpsControllerMap.containsKey(configKey)) {
            return;
        }
        LOGGER.info("Create qpsController, configKey = [{}]", (Object)configKey);
        AbstractQpsStrategy qpsStrategy = this.chooseStrategy(configKey, (Long)this.environment.getProperty(this.limitKeyPrefix + configKey, Long.class), (Long)this.environment.getProperty(this.bucketKeyPrefix + configKey, Long.class), this.environment.getProperty("servicecomb.flowcontrol.strategy"));
        this.configQpsControllerMap.put(configKey, qpsStrategy);
    }

    private void initGlobalQpsController() {
        this.globalQpsStrategy = this.chooseStrategy(this.globalLimitKey, (Long)this.environment.getProperty(this.globalLimitKey, Long.class, (Object)Integer.MAX_VALUE), (Long)this.environment.getProperty(this.globalBucketKey, Long.class), this.environment.getProperty("servicecomb.flowcontrol.strategy"));
    }

    private AbstractQpsStrategy chooseStrategy(String configKey, Long limit, Long bucket, String strategyName) {
        IStrategyFactory strategyFactory;
        if (StringUtils.isEmpty((CharSequence)strategyName)) {
            strategyName = "FixedWindow";
        }
        AbstractQpsStrategy strategy = null;
        List strategyFactories = SPIServiceUtils.getOrLoadSortedService(IStrategyFactory.class);
        Iterator iterator = strategyFactories.iterator();
        while (iterator.hasNext() && (strategy = (strategyFactory = (IStrategyFactory)iterator.next()).createStrategy(strategyName)) == null) {
        }
        if (strategy == null) {
            throw new ServiceCombException("the qps strategy name " + strategyName + " is not exist , please check.");
        }
        strategy.setKey(configKey);
        strategy.setQpsLimit(limit);
        strategy.setBucketLimit(bucket);
        return strategy;
    }
}

