# ntpq Input Plugin

Get standard NTP query metrics, requires ntpq executable.

Below is the documentation of the various headers returned from the NTP query
command when running `ntpq -p`.

- remote – The remote peer or server being synced to. “LOCAL” is this local host
(included in case there are no remote peers or servers available);
- refid – Where or what the remote peer or server is itself synchronised to;
- st (stratum) – The remote peer or server Stratum
- t (type) – Type (u: unicast or manycast client, b: broadcast or multicast client,
l: local reference clock, s: symmetric peer, A: manycast server,
B: broadcast server, M: multicast server, see “Automatic Server Discovery“);
- when – When last polled (seconds ago, “h” hours ago, or “d” days ago);
- poll – Polling frequency: rfc5905 suggests this ranges in NTPv4 from 4 (16s)
to 17 (36h) (log2 seconds), however observation suggests the actual displayed
value is seconds for a much smaller range of 64 (26) to 1024 (210) seconds;
- reach – An 8-bit left-shift shift register value recording polls (bit set =
successful, bit reset = fail) displayed in octal;
- delay – Round trip communication delay to the remote peer or server (milliseconds);
- offset – Mean offset (phase) in the times reported between this local host and
the remote peer or server (RMS, milliseconds);
- jitter – Mean deviation (jitter) in the time reported for that remote peer or
server (RMS of difference of multiple time samples, milliseconds);

## Configuration

```toml @sample.conf
# Get standard NTP query metrics, requires ntpq executable.
[[inputs.ntpq]]
  ## Servers to query with ntpq.
  ## If no server is given, the local machine is queried.
  # servers = []

  ## If false, set the -n ntpq flag. Can reduce metric gather time.
  ## DEPRECATED since 1.24.0: add '-n' to 'options' instead to skip DNS lookup
  # dns_lookup = true

  ## Options to pass to the ntpq command.
  # options = "-p"

  ## Output format for the 'reach' field.
  ## Available values are
  ##   octal   --  output as is in octal representation e.g. 377 (default)
  ##   decimal --  convert value to decimal representation e.g. 371 -> 249
  ##   count   --  count the number of bits in the value. This represents
  ##               the number of successful reaches, e.g. 37 -> 5
  ##   ratio   --  output the ratio of successful attempts e.g. 37 -> 5/8 = 0.625
  # reach_format = "octal"
```

You can pass arbitrary options accepted by the `ntpq` command using the
`options` setting. In case you want to skip DNS lookups use

```toml
  options = "-p -n"
```

for example.

## Metrics

- ntpq
  - delay (float, milliseconds)
  - jitter (float, milliseconds)
  - offset (float, milliseconds)
  - poll (int, seconds)
  - reach (int)
  - when (int, seconds)

### Tags

All measurements have the following tags:

- refid
- remote
- type
- stratum

In case you are specifying `servers`, the measurement has an
additional `source` tag.

## Example Output

```shell
$ telegraf --config ~/ws/telegraf.conf --input-filter ntpq --test
* Plugin: ntpq, Collection 1
> ntpq,refid=.GPSs.,remote=*time.apple.com,stratum=1,type=u delay=91.797,jitter=3.735,offset=12.841,poll=64i,reach=377i,when=35i 1457960478909556134
```
