// +build go1.9

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.

// This code was auto-generated by:
// github.com/Azure/azure-sdk-for-go/tools/profileBuilder

package automanage

import original "github.com/Azure/azure-sdk-for-go/services/preview/automanage/mgmt/2020-06-30-preview/automanage"

const (
	DefaultBaseURI = original.DefaultBaseURI
)

type ConfigurationProfile = original.ConfigurationProfile

const (
	AzurevirtualmachinebestpracticesDevTest    ConfigurationProfile = original.AzurevirtualmachinebestpracticesDevTest
	AzurevirtualmachinebestpracticesProduction ConfigurationProfile = original.AzurevirtualmachinebestpracticesProduction
)

type EnableRealTimeProtection = original.EnableRealTimeProtection

const (
	False EnableRealTimeProtection = original.False
	True  EnableRealTimeProtection = original.True
)

type ProvisioningState = original.ProvisioningState

const (
	Created   ProvisioningState = original.Created
	Failed    ProvisioningState = original.Failed
	Succeeded ProvisioningState = original.Succeeded
)

type ResourceIdentityType = original.ResourceIdentityType

const (
	None           ResourceIdentityType = original.None
	SystemAssigned ResourceIdentityType = original.SystemAssigned
)

type RunScheduledScan = original.RunScheduledScan

const (
	RunScheduledScanFalse RunScheduledScan = original.RunScheduledScanFalse
	RunScheduledScanTrue  RunScheduledScan = original.RunScheduledScanTrue
)

type ScanType = original.ScanType

const (
	Full  ScanType = original.Full
	Quick ScanType = original.Quick
)

type UpdateStatus = original.UpdateStatus

const (
	UpdateStatusCreated   UpdateStatus = original.UpdateStatusCreated
	UpdateStatusFailed    UpdateStatus = original.UpdateStatusFailed
	UpdateStatusSucceeded UpdateStatus = original.UpdateStatusSucceeded
)

type Account = original.Account
type AccountIdentity = original.AccountIdentity
type AccountList = original.AccountList
type AccountUpdate = original.AccountUpdate
type AccountsClient = original.AccountsClient
type AzureEntityResource = original.AzureEntityResource
type BaseClient = original.BaseClient
type ConfigurationProfileAssignment = original.ConfigurationProfileAssignment
type ConfigurationProfileAssignmentCompliance = original.ConfigurationProfileAssignmentCompliance
type ConfigurationProfileAssignmentList = original.ConfigurationProfileAssignmentList
type ConfigurationProfileAssignmentProperties = original.ConfigurationProfileAssignmentProperties
type ConfigurationProfileAssignmentsClient = original.ConfigurationProfileAssignmentsClient
type ConfigurationProfileAssignmentsCreateOrUpdateFuture = original.ConfigurationProfileAssignmentsCreateOrUpdateFuture
type ConfigurationProfilePreference = original.ConfigurationProfilePreference
type ConfigurationProfilePreferenceAntiMalware = original.ConfigurationProfilePreferenceAntiMalware
type ConfigurationProfilePreferenceList = original.ConfigurationProfilePreferenceList
type ConfigurationProfilePreferenceProperties = original.ConfigurationProfilePreferenceProperties
type ConfigurationProfilePreferenceUpdate = original.ConfigurationProfilePreferenceUpdate
type ConfigurationProfilePreferenceVMBackup = original.ConfigurationProfilePreferenceVMBackup
type ConfigurationProfilePreferencesClient = original.ConfigurationProfilePreferencesClient
type ErrorAdditionalInfo = original.ErrorAdditionalInfo
type ErrorDetail = original.ErrorDetail
type ErrorResponse = original.ErrorResponse
type Operation = original.Operation
type OperationDisplay = original.OperationDisplay
type OperationList = original.OperationList
type OperationProperties = original.OperationProperties
type OperationsClient = original.OperationsClient
type ProxyResource = original.ProxyResource
type Resource = original.Resource
type TrackedResource = original.TrackedResource
type UpdateResource = original.UpdateResource

func New(subscriptionID string) BaseClient {
	return original.New(subscriptionID)
}
func NewAccountsClient(subscriptionID string) AccountsClient {
	return original.NewAccountsClient(subscriptionID)
}
func NewAccountsClientWithBaseURI(baseURI string, subscriptionID string) AccountsClient {
	return original.NewAccountsClientWithBaseURI(baseURI, subscriptionID)
}
func NewConfigurationProfileAssignmentsClient(subscriptionID string) ConfigurationProfileAssignmentsClient {
	return original.NewConfigurationProfileAssignmentsClient(subscriptionID)
}
func NewConfigurationProfileAssignmentsClientWithBaseURI(baseURI string, subscriptionID string) ConfigurationProfileAssignmentsClient {
	return original.NewConfigurationProfileAssignmentsClientWithBaseURI(baseURI, subscriptionID)
}
func NewConfigurationProfilePreferencesClient(subscriptionID string) ConfigurationProfilePreferencesClient {
	return original.NewConfigurationProfilePreferencesClient(subscriptionID)
}
func NewConfigurationProfilePreferencesClientWithBaseURI(baseURI string, subscriptionID string) ConfigurationProfilePreferencesClient {
	return original.NewConfigurationProfilePreferencesClientWithBaseURI(baseURI, subscriptionID)
}
func NewOperationsClient(subscriptionID string) OperationsClient {
	return original.NewOperationsClient(subscriptionID)
}
func NewOperationsClientWithBaseURI(baseURI string, subscriptionID string) OperationsClient {
	return original.NewOperationsClientWithBaseURI(baseURI, subscriptionID)
}
func NewWithBaseURI(baseURI string, subscriptionID string) BaseClient {
	return original.NewWithBaseURI(baseURI, subscriptionID)
}
func PossibleConfigurationProfileValues() []ConfigurationProfile {
	return original.PossibleConfigurationProfileValues()
}
func PossibleEnableRealTimeProtectionValues() []EnableRealTimeProtection {
	return original.PossibleEnableRealTimeProtectionValues()
}
func PossibleProvisioningStateValues() []ProvisioningState {
	return original.PossibleProvisioningStateValues()
}
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return original.PossibleResourceIdentityTypeValues()
}
func PossibleRunScheduledScanValues() []RunScheduledScan {
	return original.PossibleRunScheduledScanValues()
}
func PossibleScanTypeValues() []ScanType {
	return original.PossibleScanTypeValues()
}
func PossibleUpdateStatusValues() []UpdateStatus {
	return original.PossibleUpdateStatusValues()
}
func UserAgent() string {
	return original.UserAgent() + " profiles/preview"
}
func Version() string {
	return original.Version()
}
