package das

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSqlConcurrencyControlKeywordsFromSqlText invokes the das.GetSqlConcurrencyControlKeywordsFromSqlText API synchronously
func (client *Client) GetSqlConcurrencyControlKeywordsFromSqlText(request *GetSqlConcurrencyControlKeywordsFromSqlTextRequest) (response *GetSqlConcurrencyControlKeywordsFromSqlTextResponse, err error) {
	response = CreateGetSqlConcurrencyControlKeywordsFromSqlTextResponse()
	err = client.DoAction(request, response)
	return
}

// GetSqlConcurrencyControlKeywordsFromSqlTextWithChan invokes the das.GetSqlConcurrencyControlKeywordsFromSqlText API asynchronously
func (client *Client) GetSqlConcurrencyControlKeywordsFromSqlTextWithChan(request *GetSqlConcurrencyControlKeywordsFromSqlTextRequest) (<-chan *GetSqlConcurrencyControlKeywordsFromSqlTextResponse, <-chan error) {
	responseChan := make(chan *GetSqlConcurrencyControlKeywordsFromSqlTextResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSqlConcurrencyControlKeywordsFromSqlText(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSqlConcurrencyControlKeywordsFromSqlTextWithCallback invokes the das.GetSqlConcurrencyControlKeywordsFromSqlText API asynchronously
func (client *Client) GetSqlConcurrencyControlKeywordsFromSqlTextWithCallback(request *GetSqlConcurrencyControlKeywordsFromSqlTextRequest, callback func(response *GetSqlConcurrencyControlKeywordsFromSqlTextResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSqlConcurrencyControlKeywordsFromSqlTextResponse
		var err error
		defer close(result)
		response, err = client.GetSqlConcurrencyControlKeywordsFromSqlText(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSqlConcurrencyControlKeywordsFromSqlTextRequest is the request struct for api GetSqlConcurrencyControlKeywordsFromSqlText
type GetSqlConcurrencyControlKeywordsFromSqlTextRequest struct {
	*requests.RpcRequest
	ConsoleContext string `position:"Query" name:"ConsoleContext"`
	InstanceId     string `position:"Query" name:"InstanceId"`
	SqlText        string `position:"Query" name:"SqlText"`
}

// GetSqlConcurrencyControlKeywordsFromSqlTextResponse is the response struct for api GetSqlConcurrencyControlKeywordsFromSqlText
type GetSqlConcurrencyControlKeywordsFromSqlTextResponse struct {
	*responses.BaseResponse
	Code      string `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   string `json:"Success" xml:"Success"`
}

// CreateGetSqlConcurrencyControlKeywordsFromSqlTextRequest creates a request to invoke GetSqlConcurrencyControlKeywordsFromSqlText API
func CreateGetSqlConcurrencyControlKeywordsFromSqlTextRequest() (request *GetSqlConcurrencyControlKeywordsFromSqlTextRequest) {
	request = &GetSqlConcurrencyControlKeywordsFromSqlTextRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DAS", "2020-01-16", "GetSqlConcurrencyControlKeywordsFromSqlText", "", "")
	request.Method = requests.POST
	return
}

// CreateGetSqlConcurrencyControlKeywordsFromSqlTextResponse creates a response to parse from GetSqlConcurrencyControlKeywordsFromSqlText response
func CreateGetSqlConcurrencyControlKeywordsFromSqlTextResponse() (response *GetSqlConcurrencyControlKeywordsFromSqlTextResponse) {
	response = &GetSqlConcurrencyControlKeywordsFromSqlTextResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
