package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDataServiceApiAuthority invokes the dataworks_public.DeleteDataServiceApiAuthority API synchronously
func (client *Client) DeleteDataServiceApiAuthority(request *DeleteDataServiceApiAuthorityRequest) (response *DeleteDataServiceApiAuthorityResponse, err error) {
	response = CreateDeleteDataServiceApiAuthorityResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDataServiceApiAuthorityWithChan invokes the dataworks_public.DeleteDataServiceApiAuthority API asynchronously
func (client *Client) DeleteDataServiceApiAuthorityWithChan(request *DeleteDataServiceApiAuthorityRequest) (<-chan *DeleteDataServiceApiAuthorityResponse, <-chan error) {
	responseChan := make(chan *DeleteDataServiceApiAuthorityResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDataServiceApiAuthority(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDataServiceApiAuthorityWithCallback invokes the dataworks_public.DeleteDataServiceApiAuthority API asynchronously
func (client *Client) DeleteDataServiceApiAuthorityWithCallback(request *DeleteDataServiceApiAuthorityRequest, callback func(response *DeleteDataServiceApiAuthorityResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDataServiceApiAuthorityResponse
		var err error
		defer close(result)
		response, err = client.DeleteDataServiceApiAuthority(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDataServiceApiAuthorityRequest is the request struct for api DeleteDataServiceApiAuthority
type DeleteDataServiceApiAuthorityRequest struct {
	*requests.RpcRequest
	AuthorizedProjectId requests.Integer `position:"Body" name:"AuthorizedProjectId"`
	TenantId            requests.Integer `position:"Body" name:"TenantId"`
	ProjectId           requests.Integer `position:"Body" name:"ProjectId"`
	ApiId               requests.Integer `position:"Body" name:"ApiId"`
}

// DeleteDataServiceApiAuthorityResponse is the response struct for api DeleteDataServiceApiAuthority
type DeleteDataServiceApiAuthorityResponse struct {
	*responses.BaseResponse
	Success   bool   `json:"Success" xml:"Success"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteDataServiceApiAuthorityRequest creates a request to invoke DeleteDataServiceApiAuthority API
func CreateDeleteDataServiceApiAuthorityRequest() (request *DeleteDataServiceApiAuthorityRequest) {
	request = &DeleteDataServiceApiAuthorityRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "DeleteDataServiceApiAuthority", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteDataServiceApiAuthorityResponse creates a response to parse from DeleteDataServiceApiAuthority response
func CreateDeleteDataServiceApiAuthorityResponse() (response *DeleteDataServiceApiAuthorityResponse) {
	response = &DeleteDataServiceApiAuthorityResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
