package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetNodeTypeListInfo invokes the dataworks_public.GetNodeTypeListInfo API synchronously
func (client *Client) GetNodeTypeListInfo(request *GetNodeTypeListInfoRequest) (response *GetNodeTypeListInfoResponse, err error) {
	response = CreateGetNodeTypeListInfoResponse()
	err = client.DoAction(request, response)
	return
}

// GetNodeTypeListInfoWithChan invokes the dataworks_public.GetNodeTypeListInfo API asynchronously
func (client *Client) GetNodeTypeListInfoWithChan(request *GetNodeTypeListInfoRequest) (<-chan *GetNodeTypeListInfoResponse, <-chan error) {
	responseChan := make(chan *GetNodeTypeListInfoResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetNodeTypeListInfo(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetNodeTypeListInfoWithCallback invokes the dataworks_public.GetNodeTypeListInfo API asynchronously
func (client *Client) GetNodeTypeListInfoWithCallback(request *GetNodeTypeListInfoRequest, callback func(response *GetNodeTypeListInfoResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetNodeTypeListInfoResponse
		var err error
		defer close(result)
		response, err = client.GetNodeTypeListInfo(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetNodeTypeListInfoRequest is the request struct for api GetNodeTypeListInfo
type GetNodeTypeListInfoRequest struct {
	*requests.RpcRequest
	PageSize          requests.Integer `position:"Body" name:"PageSize"`
	Keyword           string           `position:"Body" name:"Keyword"`
	Locale            string           `position:"Body" name:"Locale"`
	ProjectId         requests.Integer `position:"Body" name:"ProjectId"`
	ProjectIdentifier string           `position:"Body" name:"ProjectIdentifier"`
	PageNumber        requests.Integer `position:"Body" name:"PageNumber"`
}

// GetNodeTypeListInfoResponse is the response struct for api GetNodeTypeListInfo
type GetNodeTypeListInfoResponse struct {
	*responses.BaseResponse
	RequestId        string           `json:"RequestId" xml:"RequestId"`
	NodeTypeInfoList NodeTypeInfoList `json:"NodeTypeInfoList" xml:"NodeTypeInfoList"`
}

// CreateGetNodeTypeListInfoRequest creates a request to invoke GetNodeTypeListInfo API
func CreateGetNodeTypeListInfoRequest() (request *GetNodeTypeListInfoRequest) {
	request = &GetNodeTypeListInfoRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GetNodeTypeListInfo", "", "")
	request.Method = requests.POST
	return
}

// CreateGetNodeTypeListInfoResponse creates a response to parse from GetNodeTypeListInfo response
func CreateGetNodeTypeListInfoResponse() (response *GetNodeTypeListInfoResponse) {
	response = &GetNodeTypeListInfoResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
