package iqa

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetPredictResult invokes the iqa.GetPredictResult API synchronously
// api document: https://help.aliyun.com/api/iqa/getpredictresult.html
func (client *Client) GetPredictResult(request *GetPredictResultRequest) (response *GetPredictResultResponse, err error) {
	response = CreateGetPredictResultResponse()
	err = client.DoAction(request, response)
	return
}

// GetPredictResultWithChan invokes the iqa.GetPredictResult API asynchronously
// api document: https://help.aliyun.com/api/iqa/getpredictresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetPredictResultWithChan(request *GetPredictResultRequest) (<-chan *GetPredictResultResponse, <-chan error) {
	responseChan := make(chan *GetPredictResultResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetPredictResult(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetPredictResultWithCallback invokes the iqa.GetPredictResult API asynchronously
// api document: https://help.aliyun.com/api/iqa/getpredictresult.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetPredictResultWithCallback(request *GetPredictResultRequest, callback func(response *GetPredictResultResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetPredictResultResponse
		var err error
		defer close(result)
		response, err = client.GetPredictResult(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetPredictResultRequest is the request struct for api GetPredictResult
type GetPredictResultRequest struct {
	*requests.RpcRequest
	TopK      requests.Integer `position:"Query" name:"TopK"`
	TraceTag  string           `position:"Query" name:"TraceTag"`
	Question  string           `position:"Body" name:"Question"`
	ProjectId string           `position:"Query" name:"ProjectId"`
}

// GetPredictResultResponse is the response struct for api GetPredictResult
type GetPredictResultResponse struct {
	*responses.BaseResponse
	RequestId      string          `json:"RequestId" xml:"RequestId"`
	ProjectId      string          `json:"ProjectId" xml:"ProjectId"`
	Question       string          `json:"Question" xml:"Question"`
	TopK           int             `json:"TopK" xml:"TopK"`
	TraceTag       string          `json:"TraceTag" xml:"TraceTag"`
	CostTime       int64           `json:"CostTime" xml:"CostTime"`
	Trace          string          `json:"Trace" xml:"Trace"`
	PredictResults []PredictResult `json:"PredictResults" xml:"PredictResults"`
}

// CreateGetPredictResultRequest creates a request to invoke GetPredictResult API
func CreateGetPredictResultRequest() (request *GetPredictResultRequest) {
	request = &GetPredictResultRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("iqa", "2019-08-13", "GetPredictResult", "iqa", "openAPI")
	return
}

// CreateGetPredictResultResponse creates a response to parse from GetPredictResult response
func CreateGetPredictResultResponse() (response *GetPredictResultResponse) {
	response = &GetPredictResultResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
