package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// TransferCallToSkillGroup invokes the scsp.TransferCallToSkillGroup API synchronously
func (client *Client) TransferCallToSkillGroup(request *TransferCallToSkillGroupRequest) (response *TransferCallToSkillGroupResponse, err error) {
	response = CreateTransferCallToSkillGroupResponse()
	err = client.DoAction(request, response)
	return
}

// TransferCallToSkillGroupWithChan invokes the scsp.TransferCallToSkillGroup API asynchronously
func (client *Client) TransferCallToSkillGroupWithChan(request *TransferCallToSkillGroupRequest) (<-chan *TransferCallToSkillGroupResponse, <-chan error) {
	responseChan := make(chan *TransferCallToSkillGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.TransferCallToSkillGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// TransferCallToSkillGroupWithCallback invokes the scsp.TransferCallToSkillGroup API asynchronously
func (client *Client) TransferCallToSkillGroupWithCallback(request *TransferCallToSkillGroupRequest, callback func(response *TransferCallToSkillGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *TransferCallToSkillGroupResponse
		var err error
		defer close(result)
		response, err = client.TransferCallToSkillGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// TransferCallToSkillGroupRequest is the request struct for api TransferCallToSkillGroup
type TransferCallToSkillGroupRequest struct {
	*requests.RpcRequest
	ClientToken      string           `position:"Body"`
	InstanceId       string           `position:"Body"`
	AccountName      string           `position:"Body"`
	SkillGroupId     requests.Integer `position:"Body"`
	CallId           string           `position:"Body"`
	JobId            string           `position:"Body"`
	ConnectionId     string           `position:"Body"`
	HoldConnectionId string           `position:"Body"`
	Type             requests.Integer `position:"Body"`
	IsSingleTransfer requests.Boolean `position:"Body"`
}

// TransferCallToSkillGroupResponse is the response struct for api TransferCallToSkillGroup
type TransferCallToSkillGroupResponse struct {
	*responses.BaseResponse
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateTransferCallToSkillGroupRequest creates a request to invoke TransferCallToSkillGroup API
func CreateTransferCallToSkillGroupRequest() (request *TransferCallToSkillGroupRequest) {
	request = &TransferCallToSkillGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "TransferCallToSkillGroup", "", "")
	request.Method = requests.POST
	return
}

// CreateTransferCallToSkillGroupResponse creates a response to parse from TransferCallToSkillGroup response
func CreateTransferCallToSkillGroupResponse() (response *TransferCallToSkillGroupResponse) {
	response = &TransferCallToSkillGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
