package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListPhysicalConnectionFeatures invokes the vpc.ListPhysicalConnectionFeatures API synchronously
func (client *Client) ListPhysicalConnectionFeatures(request *ListPhysicalConnectionFeaturesRequest) (response *ListPhysicalConnectionFeaturesResponse, err error) {
	response = CreateListPhysicalConnectionFeaturesResponse()
	err = client.DoAction(request, response)
	return
}

// ListPhysicalConnectionFeaturesWithChan invokes the vpc.ListPhysicalConnectionFeatures API asynchronously
func (client *Client) ListPhysicalConnectionFeaturesWithChan(request *ListPhysicalConnectionFeaturesRequest) (<-chan *ListPhysicalConnectionFeaturesResponse, <-chan error) {
	responseChan := make(chan *ListPhysicalConnectionFeaturesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListPhysicalConnectionFeatures(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListPhysicalConnectionFeaturesWithCallback invokes the vpc.ListPhysicalConnectionFeatures API asynchronously
func (client *Client) ListPhysicalConnectionFeaturesWithCallback(request *ListPhysicalConnectionFeaturesRequest, callback func(response *ListPhysicalConnectionFeaturesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListPhysicalConnectionFeaturesResponse
		var err error
		defer close(result)
		response, err = client.ListPhysicalConnectionFeatures(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListPhysicalConnectionFeaturesRequest is the request struct for api ListPhysicalConnectionFeatures
type ListPhysicalConnectionFeaturesRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount         string           `position:"Query" name:"OwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	PhysicalConnectionId string           `position:"Query" name:"PhysicalConnectionId"`
}

// ListPhysicalConnectionFeaturesResponse is the response struct for api ListPhysicalConnectionFeatures
type ListPhysicalConnectionFeaturesResponse struct {
	*responses.BaseResponse
	RequestId                  string                      `json:"RequestId" xml:"RequestId"`
	PhysicalConnectionFeatures []PhysicalConnectionFeature `json:"PhysicalConnectionFeatures" xml:"PhysicalConnectionFeatures"`
}

// CreateListPhysicalConnectionFeaturesRequest creates a request to invoke ListPhysicalConnectionFeatures API
func CreateListPhysicalConnectionFeaturesRequest() (request *ListPhysicalConnectionFeaturesRequest) {
	request = &ListPhysicalConnectionFeaturesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "ListPhysicalConnectionFeatures", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListPhysicalConnectionFeaturesResponse creates a response to parse from ListPhysicalConnectionFeatures response
func CreateListPhysicalConnectionFeaturesResponse() (response *ListPhysicalConnectionFeaturesResponse) {
	response = &ListPhysicalConnectionFeaturesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
