# Redis


## Fields

| Field                                                                                                              | Type                                                                                                               | Required                                                                                                           | Description                                                                                                        |
| ------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------------ |
| `ArchBits`                                                                                                         | **string*                                                                                                          | :heavy_minus_sign:                                                                                                 | The architecture bits (32 or 64) the Redis server used to build.                                                   |
| `AuthResponse`                                                                                                     | **string*                                                                                                          | :heavy_minus_sign:                                                                                                 | The response from the AUTH command, if sent.                                                                       |
| `BuildID`                                                                                                          | **string*                                                                                                          | :heavy_minus_sign:                                                                                                 | The Build ID of the Redis server.                                                                                  |
| `Commands`                                                                                                         | []*string*                                                                                                         | :heavy_minus_sign:                                                                                                 | The list of commands actually sent to the server, serialized in inline format, like 'PING' or 'AUTH somePassword'. |
| `CommandsProcessed`                                                                                                | **int*                                                                                                             | :heavy_minus_sign:                                                                                                 | The total number of commands processed by the server.                                                              |
| `ConnectionsReceived`                                                                                              | **int*                                                                                                             | :heavy_minus_sign:                                                                                                 | The total number of connections accepted by the server.                                                            |
| `GccVersion`                                                                                                       | **string*                                                                                                          | :heavy_minus_sign:                                                                                                 | The version of the GCC compiler used to compile the Redis server.                                                  |
| `GitSha1`                                                                                                          | **string*                                                                                                          | :heavy_minus_sign:                                                                                                 | The Sha-1 Git commit hash the Redis server used.                                                                   |
| `InfoResponse`                                                                                                     | map[string]*string*                                                                                                | :heavy_minus_sign:                                                                                                 | The response from the INFO command. Should be a series of key:value pairs separated by CRLFs.                      |
| `Major`                                                                                                            | **int*                                                                                                             | :heavy_minus_sign:                                                                                                 | Major is the version's major number.                                                                               |
| `MemAllocator`                                                                                                     | **string*                                                                                                          | :heavy_minus_sign:                                                                                                 | The memory allocator.                                                                                              |
| `Minor`                                                                                                            | **int*                                                                                                             | :heavy_minus_sign:                                                                                                 | Minor is the version's major number.                                                                               |
| `Mode`                                                                                                             | **string*                                                                                                          | :heavy_minus_sign:                                                                                                 | The mode the Redis server is running (standalone or cluster), read from the the info_response (if available).      |
| `NonexistentResponse`                                                                                              | **string*                                                                                                          | :heavy_minus_sign:                                                                                                 | The response from the NONEXISTENT command.                                                                         |
| `Os`                                                                                                               | **string*                                                                                                          | :heavy_minus_sign:                                                                                                 | The OS the Redis server is running, read from the the info_response (if available).                                |
| `PatchLevel`                                                                                                       | **int*                                                                                                             | :heavy_minus_sign:                                                                                                 | Patchlevel is the version's patchlevel number.                                                                     |
| `PingResponse`                                                                                                     | **string*                                                                                                          | :heavy_minus_sign:                                                                                                 | The response from the PING command; should either be "PONG" or an authentication error.                            |
| `QuitResponse`                                                                                                     | **string*                                                                                                          | :heavy_minus_sign:                                                                                                 | The response to the QUIT command.                                                                                  |
| `RawCommandOutput`                                                                                                 | [][components.RedisRawOutput](../../models/components/redisrawoutput.md)                                           | :heavy_minus_sign:                                                                                                 | The raw output returned by the server for each command sent; the indices match those of commands.                  |
| `Uptime`                                                                                                           | **int*                                                                                                             | :heavy_minus_sign:                                                                                                 | The number of seconds since Redis server start.                                                                    |
| `UsedMemory`                                                                                                       | **int*                                                                                                             | :heavy_minus_sign:                                                                                                 | The total number of bytes allocated by Redis using its allocator.                                                  |