// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.


package v1

import (
	"bytes"
	"context"
	"fmt"
	"io/ioutil"
	"math"
	"net/http"
	"net/url"

	protocolspb "github.com/coinbase/waas-client-library-go/gen/go/coinbase/cloud/protocols/v1"
	typespb "github.com/coinbase/waas-client-library-go/gen/go/coinbase/cloud/types/v1"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/googleapi"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	"google.golang.org/grpc"
	"google.golang.org/grpc/metadata"
	"google.golang.org/protobuf/encoding/protojson"
)

var newProtocolClientHook clientHook

// ProtocolCallOptions contains the retry settings for each method of ProtocolClient.
type ProtocolCallOptions struct {
	ConstructTransaction []gax.CallOption
	ConstructTransferTransaction []gax.CallOption
	BroadcastTransaction []gax.CallOption
	EstimateFee []gax.CallOption
}

func defaultProtocolGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("api.developer.coinbase.com/waas/protocols:443"),
		internaloption.WithDefaultMTLSEndpoint("api.developer.coinbase.com/waas/protocols:443"),
		internaloption.WithDefaultAudience("https://api.developer.coinbase.com/waas/protocols/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
		grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultProtocolCallOptions() *ProtocolCallOptions {
	return &ProtocolCallOptions{
		ConstructTransaction: []gax.CallOption{
		},
		ConstructTransferTransaction: []gax.CallOption{
		},
		BroadcastTransaction: []gax.CallOption{
		},
		EstimateFee: []gax.CallOption{
		},
	}
}

func defaultProtocolRESTCallOptions() *ProtocolCallOptions {
	return &ProtocolCallOptions{
		ConstructTransaction: []gax.CallOption{
		},
		ConstructTransferTransaction: []gax.CallOption{
		},
		BroadcastTransaction: []gax.CallOption{
		},
		EstimateFee: []gax.CallOption{
		},
	}
}

// internalProtocolClient is an interface that defines the methods available from .
type internalProtocolClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	ConstructTransaction(context.Context, *protocolspb.ConstructTransactionRequest, ...gax.CallOption) (*typespb.Transaction, error)
	ConstructTransferTransaction(context.Context, *protocolspb.ConstructTransferTransactionRequest, ...gax.CallOption) (*typespb.Transaction, error)
	BroadcastTransaction(context.Context, *protocolspb.BroadcastTransactionRequest, ...gax.CallOption) (*typespb.Transaction, error)
	EstimateFee(context.Context, *protocolspb.EstimateFeeRequest, ...gax.CallOption) (*protocolspb.EstimateFeeResponse, error)
}

// ProtocolClient is a client for interacting with .
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// A service providing a set of stateless APIs for constructing and broadcasting
// Network-specific transactions.
type ProtocolClient struct {
	// The internal transport-dependent client.
	internalClient internalProtocolClient

	// The call options for this service.
	CallOptions *ProtocolCallOptions

}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *ProtocolClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *ProtocolClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *ProtocolClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// ConstructTransaction constructs an unsigned transaction. The payloads in the required_signatures of the
// returned Transaction must be signed before the Transaction is broadcast.
func (c *ProtocolClient) ConstructTransaction(ctx context.Context, req *protocolspb.ConstructTransactionRequest, opts ...gax.CallOption) (*typespb.Transaction, error) {
	return c.internalClient.ConstructTransaction(ctx, req, opts...)
}

// ConstructTransferTransaction constructs an unsigned transfer transaction. A transfer transaction is a transaction that
// moves an Asset from one Address to another. The payloads in the required_signatures of the
// returned Transaction must be signed before the Transaction is broadcast.
func (c *ProtocolClient) ConstructTransferTransaction(ctx context.Context, req *protocolspb.ConstructTransferTransactionRequest, opts ...gax.CallOption) (*typespb.Transaction, error) {
	return c.internalClient.ConstructTransferTransaction(ctx, req, opts...)
}

// BroadcastTransaction broadcasts a transaction to a node in the Network. There are two ways of invoking this API:
//
// Set the raw_signed_transaction on the Transaction. This is equivalent to the payload used to broadcast transactions
// via block explorers such as Etherscan. In this case, the TransactionInput does not need to be set on the Transaction.
//
// Set the signature(s) in the required_signatures of the Transaction. In this case, the TransactionInput must also be
// set on the Transaction.
// The Transaction returned will have the hash set on it.
func (c *ProtocolClient) BroadcastTransaction(ctx context.Context, req *protocolspb.BroadcastTransactionRequest, opts ...gax.CallOption) (*typespb.Transaction, error) {
	return c.internalClient.BroadcastTransaction(ctx, req, opts...)
}

// EstimateFee estimates the current network fee for the specified Network. For EVM Networks, this
// corresponds to the gas_price, max_fee_per_gas, and max_priority_fee_per_gas.
func (c *ProtocolClient) EstimateFee(ctx context.Context, req *protocolspb.EstimateFeeRequest, opts ...gax.CallOption) (*protocolspb.EstimateFeeResponse, error) {
	return c.internalClient.EstimateFee(ctx, req, opts...)
}

// protocolGRPCClient is a client for interacting with  over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type protocolGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// flag to opt out of default deadlines via GOOGLE_API_GO_EXPERIMENTAL_DISABLE_DEFAULT_DEADLINE
	disableDeadlines bool

	// Points back to the CallOptions field of the containing ProtocolClient
	CallOptions **ProtocolCallOptions

	// The gRPC API client.
	protocolClient protocolspb.ProtocolServiceClient

	// The x-goog-* metadata to be sent with each request.
	xGoogMetadata metadata.MD
}

// NewProtocolClient creates a new protocol service client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// A service providing a set of stateless APIs for constructing and broadcasting
// Network-specific transactions.
func NewProtocolClient(ctx context.Context, opts ...option.ClientOption) (*ProtocolClient, error) {
	clientOpts := defaultProtocolGRPCClientOptions()
	if newProtocolClientHook != nil {
		hookOpts, err := newProtocolClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	disableDeadlines, err := checkDisableDeadlines()
	if err != nil {
		return nil, err
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := ProtocolClient{CallOptions: defaultProtocolCallOptions()}

	c := &protocolGRPCClient{
		connPool:    connPool,
		disableDeadlines: disableDeadlines,
		protocolClient: protocolspb.NewProtocolServiceClient(connPool),
		CallOptions: &client.CallOptions,

	}
	c.setGoogleClientInfo()

	client.internalClient = c

	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *protocolGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *protocolGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", versionGo()}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogMetadata = metadata.Pairs("x-goog-api-client", gax.XGoogHeader(kv...))
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *protocolGRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type protocolRESTClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// The x-goog-* metadata to be sent with each request.
	xGoogMetadata metadata.MD

	// Points back to the CallOptions field of the containing ProtocolClient
	CallOptions **ProtocolCallOptions
}

// NewProtocolRESTClient creates a new protocol service rest client.
//
// A service providing a set of stateless APIs for constructing and broadcasting
// Network-specific transactions.
func NewProtocolRESTClient(ctx context.Context, opts ...option.ClientOption) (*ProtocolClient, error) {
	clientOpts := append(defaultProtocolRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultProtocolRESTCallOptions()
	c := &protocolRESTClient{
		endpoint: endpoint,
		httpClient: httpClient,
		CallOptions: &callOpts,
	}
	c.setGoogleClientInfo()

	return &ProtocolClient{internalClient: c, CallOptions: callOpts}, nil
}

func defaultProtocolRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://api.developer.coinbase.com/waas/protocols"),
		internaloption.WithDefaultMTLSEndpoint("https://api.developer.coinbase.com/waas/protocols"),
		internaloption.WithDefaultAudience("https://api.developer.coinbase.com/waas/protocols/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
	}
}
// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *protocolRESTClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", versionGo()}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN")
	c.xGoogMetadata = metadata.Pairs("x-goog-api-client", gax.XGoogHeader(kv...))
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *protocolRESTClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *protocolRESTClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *protocolGRPCClient) ConstructTransaction(ctx context.Context, req *protocolspb.ConstructTransactionRequest, opts ...gax.CallOption) (*typespb.Transaction, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "network", url.QueryEscape(req.GetNetwork())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ConstructTransaction[0:len((*c.CallOptions).ConstructTransaction):len((*c.CallOptions).ConstructTransaction)], opts...)
	var resp *typespb.Transaction
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.protocolClient.ConstructTransaction(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *protocolGRPCClient) ConstructTransferTransaction(ctx context.Context, req *protocolspb.ConstructTransferTransactionRequest, opts ...gax.CallOption) (*typespb.Transaction, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "network", url.QueryEscape(req.GetNetwork())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).ConstructTransferTransaction[0:len((*c.CallOptions).ConstructTransferTransaction):len((*c.CallOptions).ConstructTransferTransaction)], opts...)
	var resp *typespb.Transaction
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.protocolClient.ConstructTransferTransaction(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *protocolGRPCClient) BroadcastTransaction(ctx context.Context, req *protocolspb.BroadcastTransactionRequest, opts ...gax.CallOption) (*typespb.Transaction, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "network", url.QueryEscape(req.GetNetwork())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).BroadcastTransaction[0:len((*c.CallOptions).BroadcastTransaction):len((*c.CallOptions).BroadcastTransaction)], opts...)
	var resp *typespb.Transaction
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.protocolClient.BroadcastTransaction(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *protocolGRPCClient) EstimateFee(ctx context.Context, req *protocolspb.EstimateFeeRequest, opts ...gax.CallOption) (*protocolspb.EstimateFeeResponse, error) {
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "network", url.QueryEscape(req.GetNetwork())))

	ctx = insertMetadata(ctx, c.xGoogMetadata, md)
	opts = append((*c.CallOptions).EstimateFee[0:len((*c.CallOptions).EstimateFee):len((*c.CallOptions).EstimateFee)], opts...)
	var resp *protocolspb.EstimateFeeResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = c.protocolClient.EstimateFee(ctx, req, settings.GRPC...)
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// ConstructTransaction constructs an unsigned transaction. The payloads in the required_signatures of the
// returned Transaction must be signed before the Transaction is broadcast.
func (c *protocolRESTClient) ConstructTransaction(ctx context.Context, req *protocolspb.ConstructTransactionRequest, opts ...gax.CallOption) (*typespb.Transaction, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:constructTransaction", req.GetNetwork())

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "network", url.QueryEscape(req.GetNetwork())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	opts = append((*c.CallOptions).ConstructTransaction[0:len((*c.CallOptions).ConstructTransaction):len((*c.CallOptions).ConstructTransaction)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &typespb.Transaction{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil{
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := ioutil.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return maybeUnknownEnum(err)
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}
// ConstructTransferTransaction constructs an unsigned transfer transaction. A transfer transaction is a transaction that
// moves an Asset from one Address to another. The payloads in the required_signatures of the
// returned Transaction must be signed before the Transaction is broadcast.
func (c *protocolRESTClient) ConstructTransferTransaction(ctx context.Context, req *protocolspb.ConstructTransferTransactionRequest, opts ...gax.CallOption) (*typespb.Transaction, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:constructTransferTransaction", req.GetNetwork())

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "network", url.QueryEscape(req.GetNetwork())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	opts = append((*c.CallOptions).ConstructTransferTransaction[0:len((*c.CallOptions).ConstructTransferTransaction):len((*c.CallOptions).ConstructTransferTransaction)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &typespb.Transaction{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil{
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := ioutil.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return maybeUnknownEnum(err)
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}
// BroadcastTransaction broadcasts a transaction to a node in the Network. There are two ways of invoking this API:
//
// Set the raw_signed_transaction on the Transaction. This is equivalent to the payload used to broadcast transactions
// via block explorers such as Etherscan. In this case, the TransactionInput does not need to be set on the Transaction.
//
// Set the signature(s) in the required_signatures of the Transaction. In this case, the TransactionInput must also be
// set on the Transaction.
// The Transaction returned will have the hash set on it.
func (c *protocolRESTClient) BroadcastTransaction(ctx context.Context, req *protocolspb.BroadcastTransactionRequest, opts ...gax.CallOption) (*typespb.Transaction, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:broadcastTransaction", req.GetNetwork())

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "network", url.QueryEscape(req.GetNetwork())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	opts = append((*c.CallOptions).BroadcastTransaction[0:len((*c.CallOptions).BroadcastTransaction):len((*c.CallOptions).BroadcastTransaction)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &typespb.Transaction{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil{
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := ioutil.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return maybeUnknownEnum(err)
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}
// EstimateFee estimates the current network fee for the specified Network. For EVM Networks, this
// corresponds to the gas_price, max_fee_per_gas, and max_priority_fee_per_gas.
func (c *protocolRESTClient) EstimateFee(ctx context.Context, req *protocolspb.EstimateFeeRequest, opts ...gax.CallOption) (*protocolspb.EstimateFeeResponse, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:estimateFee", req.GetNetwork())

	// Build HTTP headers from client and context metadata.
	md := metadata.Pairs("x-goog-request-params", fmt.Sprintf("%s=%v", "network", url.QueryEscape(req.GetNetwork())))

	headers := buildHeaders(ctx, c.xGoogMetadata, md, metadata.Pairs("Content-Type", "application/json"))
	opts = append((*c.CallOptions).EstimateFee[0:len((*c.CallOptions).EstimateFee):len((*c.CallOptions).EstimateFee)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &protocolspb.EstimateFeeResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		httpRsp, err := c.httpClient.Do(httpReq)
		if err != nil{
			return err
		}
		defer httpRsp.Body.Close()

		if err = googleapi.CheckResponse(httpRsp); err != nil {
			return err
		}

		buf, err := ioutil.ReadAll(httpRsp.Body)
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return maybeUnknownEnum(err)
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}
