// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// HashicorpCloudVagrantDownloadProviderResponse hashicorp cloud vagrant download provider response
//
// swagger:model hashicorp.cloud.vagrant.DownloadProviderResponse
type HashicorpCloudVagrantDownloadProviderResponse struct {

	// (Optional) checksum data to validate the download with. This field may
	// not be populated for Hosted Provider downloads.
	Checksum string `json:"checksum,omitempty"`

	// The algorithm type for the provided checksum.
	ChecksumType *HashicorpCloudVagrantDownloadProviderResponseChecksumType `json:"checksum_type,omitempty"`

	// The URL to download the Provider data from.
	URL string `json:"url,omitempty"`
}

// Validate validates this hashicorp cloud vagrant download provider response
func (m *HashicorpCloudVagrantDownloadProviderResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateChecksumType(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudVagrantDownloadProviderResponse) validateChecksumType(formats strfmt.Registry) error {
	if swag.IsZero(m.ChecksumType) { // not required
		return nil
	}

	if m.ChecksumType != nil {
		if err := m.ChecksumType.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("checksum_type")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("checksum_type")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this hashicorp cloud vagrant download provider response based on the context it is used
func (m *HashicorpCloudVagrantDownloadProviderResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateChecksumType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudVagrantDownloadProviderResponse) contextValidateChecksumType(ctx context.Context, formats strfmt.Registry) error {

	if m.ChecksumType != nil {
		if err := m.ChecksumType.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("checksum_type")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("checksum_type")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudVagrantDownloadProviderResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudVagrantDownloadProviderResponse) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudVagrantDownloadProviderResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
