// Code generated by ent, DO NOT EDIT.

package feed

import (
	"time"

	"entgo.io/ent/dialect/sql"
	"entgo.io/ent/dialect/sql/sqlgraph"
	"github.com/google/uuid"
)

const (
	// Label holds the string label denoting the feed type in the database.
	Label = "feed"
	// FieldID holds the string denoting the id field in the database.
	FieldID = "id"
	// FieldURL holds the string denoting the url field in the database.
	FieldURL = "url"
	// FieldUsername holds the string denoting the username field in the database.
	FieldUsername = "username"
	// FieldPassword holds the string denoting the password field in the database.
	FieldPassword = "password"
	// FieldFeedTitle holds the string denoting the feed_title field in the database.
	FieldFeedTitle = "feed_title"
	// FieldFeedDescription holds the string denoting the feed_description field in the database.
	FieldFeedDescription = "feed_description"
	// FieldFeedLink holds the string denoting the feed_link field in the database.
	FieldFeedLink = "feed_link"
	// FieldFeedFeedLink holds the string denoting the feed_feed_link field in the database.
	FieldFeedFeedLink = "feed_feed_link"
	// FieldFeedUpdated holds the string denoting the feed_updated field in the database.
	FieldFeedUpdated = "feed_updated"
	// FieldFeedPublished holds the string denoting the feed_published field in the database.
	FieldFeedPublished = "feed_published"
	// FieldFeedAuthorName holds the string denoting the feed_author_name field in the database.
	FieldFeedAuthorName = "feed_author_name"
	// FieldFeedAuthorEmail holds the string denoting the feed_author_email field in the database.
	FieldFeedAuthorEmail = "feed_author_email"
	// FieldFeedLanguage holds the string denoting the feed_language field in the database.
	FieldFeedLanguage = "feed_language"
	// FieldFeedImageTitle holds the string denoting the feed_image_title field in the database.
	FieldFeedImageTitle = "feed_image_title"
	// FieldFeedImageURL holds the string denoting the feed_image_url field in the database.
	FieldFeedImageURL = "feed_image_url"
	// FieldFeedCopyright holds the string denoting the feed_copyright field in the database.
	FieldFeedCopyright = "feed_copyright"
	// FieldFeedGenerator holds the string denoting the feed_generator field in the database.
	FieldFeedGenerator = "feed_generator"
	// FieldFeedCategories holds the string denoting the feed_categories field in the database.
	FieldFeedCategories = "feed_categories"
	// FieldCreatedAt holds the string denoting the created_at field in the database.
	FieldCreatedAt = "created_at"
	// FieldUpdatedAt holds the string denoting the updated_at field in the database.
	FieldUpdatedAt = "updated_at"
	// FieldDeletedAt holds the string denoting the deleted_at field in the database.
	FieldDeletedAt = "deleted_at"
	// EdgeItems holds the string denoting the items edge name in mutations.
	EdgeItems = "items"
	// EdgeSubscribedUsers holds the string denoting the subscribed_users edge name in mutations.
	EdgeSubscribedUsers = "subscribed_users"
	// EdgeSubscriptions holds the string denoting the subscriptions edge name in mutations.
	EdgeSubscriptions = "subscriptions"
	// Table holds the table name of the feed in the database.
	Table = "feeds"
	// ItemsTable is the table that holds the items relation/edge.
	ItemsTable = "items"
	// ItemsInverseTable is the table name for the Item entity.
	// It exists in this package in order to avoid circular dependency with the "item" package.
	ItemsInverseTable = "items"
	// ItemsColumn is the table column denoting the items relation/edge.
	ItemsColumn = "feed_items"
	// SubscribedUsersTable is the table that holds the subscribed_users relation/edge. The primary key declared below.
	SubscribedUsersTable = "subscriptions"
	// SubscribedUsersInverseTable is the table name for the User entity.
	// It exists in this package in order to avoid circular dependency with the "user" package.
	SubscribedUsersInverseTable = "users"
	// SubscriptionsTable is the table that holds the subscriptions relation/edge.
	SubscriptionsTable = "subscriptions"
	// SubscriptionsInverseTable is the table name for the Subscription entity.
	// It exists in this package in order to avoid circular dependency with the "subscription" package.
	SubscriptionsInverseTable = "subscriptions"
	// SubscriptionsColumn is the table column denoting the subscriptions relation/edge.
	SubscriptionsColumn = "feed_id"
)

// Columns holds all SQL columns for feed fields.
var Columns = []string{
	FieldID,
	FieldURL,
	FieldUsername,
	FieldPassword,
	FieldFeedTitle,
	FieldFeedDescription,
	FieldFeedLink,
	FieldFeedFeedLink,
	FieldFeedUpdated,
	FieldFeedPublished,
	FieldFeedAuthorName,
	FieldFeedAuthorEmail,
	FieldFeedLanguage,
	FieldFeedImageTitle,
	FieldFeedImageURL,
	FieldFeedCopyright,
	FieldFeedGenerator,
	FieldFeedCategories,
	FieldCreatedAt,
	FieldUpdatedAt,
	FieldDeletedAt,
}

var (
	// SubscribedUsersPrimaryKey and SubscribedUsersColumn2 are the table columns denoting the
	// primary key for the subscribed_users relation (M2M).
	SubscribedUsersPrimaryKey = []string{"user_id", "feed_id"}
)

// ValidColumn reports if the column name is valid (part of the table columns).
func ValidColumn(column string) bool {
	for i := range Columns {
		if column == Columns[i] {
			return true
		}
	}
	return false
}

var (
	// URLValidator is a validator for the "url" field. It is called by the builders before save.
	URLValidator func(string) error
	// DefaultUsername holds the default value on creation for the "username" field.
	DefaultUsername string
	// DefaultPassword holds the default value on creation for the "password" field.
	DefaultPassword string
	// DefaultCreatedAt holds the default value on creation for the "created_at" field.
	DefaultCreatedAt func() time.Time
	// DefaultUpdatedAt holds the default value on creation for the "updated_at" field.
	DefaultUpdatedAt func() time.Time
	// UpdateDefaultUpdatedAt holds the default value on update for the "updated_at" field.
	UpdateDefaultUpdatedAt func() time.Time
	// DefaultID holds the default value on creation for the "id" field.
	DefaultID func() uuid.UUID
)

// OrderOption defines the ordering options for the Feed queries.
type OrderOption func(*sql.Selector)

// ByID orders the results by the id field.
func ByID(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldID, opts...).ToFunc()
}

// ByURL orders the results by the url field.
func ByURL(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldURL, opts...).ToFunc()
}

// ByUsername orders the results by the username field.
func ByUsername(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldUsername, opts...).ToFunc()
}

// ByPassword orders the results by the password field.
func ByPassword(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldPassword, opts...).ToFunc()
}

// ByFeedTitle orders the results by the feed_title field.
func ByFeedTitle(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldFeedTitle, opts...).ToFunc()
}

// ByFeedDescription orders the results by the feed_description field.
func ByFeedDescription(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldFeedDescription, opts...).ToFunc()
}

// ByFeedLink orders the results by the feed_link field.
func ByFeedLink(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldFeedLink, opts...).ToFunc()
}

// ByFeedFeedLink orders the results by the feed_feed_link field.
func ByFeedFeedLink(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldFeedFeedLink, opts...).ToFunc()
}

// ByFeedUpdated orders the results by the feed_updated field.
func ByFeedUpdated(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldFeedUpdated, opts...).ToFunc()
}

// ByFeedPublished orders the results by the feed_published field.
func ByFeedPublished(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldFeedPublished, opts...).ToFunc()
}

// ByFeedAuthorName orders the results by the feed_author_name field.
func ByFeedAuthorName(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldFeedAuthorName, opts...).ToFunc()
}

// ByFeedAuthorEmail orders the results by the feed_author_email field.
func ByFeedAuthorEmail(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldFeedAuthorEmail, opts...).ToFunc()
}

// ByFeedLanguage orders the results by the feed_language field.
func ByFeedLanguage(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldFeedLanguage, opts...).ToFunc()
}

// ByFeedImageTitle orders the results by the feed_image_title field.
func ByFeedImageTitle(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldFeedImageTitle, opts...).ToFunc()
}

// ByFeedImageURL orders the results by the feed_image_url field.
func ByFeedImageURL(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldFeedImageURL, opts...).ToFunc()
}

// ByFeedCopyright orders the results by the feed_copyright field.
func ByFeedCopyright(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldFeedCopyright, opts...).ToFunc()
}

// ByFeedGenerator orders the results by the feed_generator field.
func ByFeedGenerator(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldFeedGenerator, opts...).ToFunc()
}

// ByFeedCategories orders the results by the feed_categories field.
func ByFeedCategories(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldFeedCategories, opts...).ToFunc()
}

// ByCreatedAt orders the results by the created_at field.
func ByCreatedAt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldCreatedAt, opts...).ToFunc()
}

// ByUpdatedAt orders the results by the updated_at field.
func ByUpdatedAt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldUpdatedAt, opts...).ToFunc()
}

// ByDeletedAt orders the results by the deleted_at field.
func ByDeletedAt(opts ...sql.OrderTermOption) OrderOption {
	return sql.OrderByField(FieldDeletedAt, opts...).ToFunc()
}

// ByItemsCount orders the results by items count.
func ByItemsCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newItemsStep(), opts...)
	}
}

// ByItems orders the results by items terms.
func ByItems(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newItemsStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}

// BySubscribedUsersCount orders the results by subscribed_users count.
func BySubscribedUsersCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newSubscribedUsersStep(), opts...)
	}
}

// BySubscribedUsers orders the results by subscribed_users terms.
func BySubscribedUsers(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newSubscribedUsersStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}

// BySubscriptionsCount orders the results by subscriptions count.
func BySubscriptionsCount(opts ...sql.OrderTermOption) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborsCount(s, newSubscriptionsStep(), opts...)
	}
}

// BySubscriptions orders the results by subscriptions terms.
func BySubscriptions(term sql.OrderTerm, terms ...sql.OrderTerm) OrderOption {
	return func(s *sql.Selector) {
		sqlgraph.OrderByNeighborTerms(s, newSubscriptionsStep(), append([]sql.OrderTerm{term}, terms...)...)
	}
}
func newItemsStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(ItemsInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.O2M, false, ItemsTable, ItemsColumn),
	)
}
func newSubscribedUsersStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(SubscribedUsersInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.M2M, true, SubscribedUsersTable, SubscribedUsersPrimaryKey...),
	)
}
func newSubscriptionsStep() *sqlgraph.Step {
	return sqlgraph.NewStep(
		sqlgraph.From(Table, FieldID),
		sqlgraph.To(SubscriptionsInverseTable, FieldID),
		sqlgraph.Edge(sqlgraph.O2M, true, SubscriptionsTable, SubscriptionsColumn),
	)
}
