// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Java Management Service Fleets API
//
// The APIs for the Fleet Management (https://docs.oracle.com/en-us/iaas/jms/doc/fleet-management.html) feature of Java Management Service to monitor and manage the usage of Java in your enterprise. Use these APIs to manage fleets, configure managed instances to report to fleets, and gain insights into the Java workloads running on these instances by carrying out basic and advanced features.
//

package jms

import (
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// JavaFamily Metadata associated with a specific Java release family.
// A Java release family is typically a major version in the Java version identifier.
type JavaFamily struct {

	// The Java release family identifier.
	FamilyVersion *string `mandatory:"true" json:"familyVersion"`

	// The display name of the release family.
	DisplayName *string `mandatory:"true" json:"displayName"`

	// This indicates the support category for the Java release family.
	SupportType SupportTypeEnum `mandatory:"true" json:"supportType"`

	// The End of Support Life (EOSL) date of the Java release family (formatted according to RFC3339 (https://datatracker.ietf.org/doc/html/rfc3339)).
	EndOfSupportLifeDate *common.SDKTime `mandatory:"true" json:"endOfSupportLifeDate"`

	// Link to access the documentation for the release.
	DocUrl *string `mandatory:"true" json:"docUrl"`

	// Latest Java release version in the family.
	LatestReleaseVersion *string `mandatory:"true" json:"latestReleaseVersion"`

	// Whether or not this Java release family is under active support.
	// Refer Java Support Roadmap (https://www.oracle.com/java/technologies/java-se-support-roadmap.html) for more details.
	IsSupportedVersion *bool `mandatory:"true" json:"isSupportedVersion"`

	// The date on which the Java release family was first made available (formatted according to RFC3339 (https://datatracker.ietf.org/doc/html/rfc3339)).
	ReleaseDate *common.SDKTime `mandatory:"false" json:"releaseDate"`

	// List of artifacts for the latest Java release version in this family.
	// The script URLs in the response can be used from a command line, or in scripts and dockerfiles to always get the artifacts corresponding to the latest update release version.
	LatestReleaseArtifacts []JavaArtifact `mandatory:"false" json:"latestReleaseArtifacts"`
}

func (m JavaFamily) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m JavaFamily) ValidateEnumValue() (bool, error) {
	errMessage := []string{}
	if _, ok := GetMappingSupportTypeEnum(string(m.SupportType)); !ok && m.SupportType != "" {
		errMessage = append(errMessage, fmt.Sprintf("unsupported enum value for SupportType: %s. Supported values are: %s.", m.SupportType, strings.Join(GetSupportTypeEnumStringValues(), ",")))
	}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}
