// Copyright (c) 2016, 2018, 2024, Oracle and/or its affiliates.  All rights reserved.
// This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.
// Code generated. DO NOT EDIT.

// Scanning API
//
// Use the Vulnerability Scanning Service (VSS) API to manage scan recipes, targets, and reports. For more information, see the Vulnerability Scanning documentation (https://docs.cloud.oracle.com/iaas/scanning/home.htm).
//

package vulnerabilityscanning

import (
	"encoding/json"
	"fmt"
	"github.com/oracle/oci-go-sdk/v65/common"
	"strings"
)

// UpdateOcirContainerScanRegistryDetails Registry information for a OCI Registry target
type UpdateOcirContainerScanRegistryDetails struct {

	// URL of the registry. Required for non-OCIR registry types (for OCIR registry types, it can be inferred from the tenancy). If null, will not be updated.
	Url *string `mandatory:"false" json:"url"`

	// The OCID (https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment to perform the scans in. All listed repositories must be in the compartment.
	CompartmentId *string `mandatory:"false" json:"compartmentId"`

	// List of repositories to scan images in. If left empty, the target defaults to scanning all repos in the compartmentId
	Repositories []string `mandatory:"false" json:"repositories"`
}

// GetUrl returns Url
func (m UpdateOcirContainerScanRegistryDetails) GetUrl() *string {
	return m.Url
}

func (m UpdateOcirContainerScanRegistryDetails) String() string {
	return common.PointerString(m)
}

// ValidateEnumValue returns an error when providing an unsupported enum value
// This function is being called during constructing API request process
// Not recommended for calling this function directly
func (m UpdateOcirContainerScanRegistryDetails) ValidateEnumValue() (bool, error) {
	errMessage := []string{}

	if len(errMessage) > 0 {
		return true, fmt.Errorf(strings.Join(errMessage, "\n"))
	}
	return false, nil
}

// MarshalJSON marshals to json representation
func (m UpdateOcirContainerScanRegistryDetails) MarshalJSON() (buff []byte, e error) {
	type MarshalTypeUpdateOcirContainerScanRegistryDetails UpdateOcirContainerScanRegistryDetails
	s := struct {
		DiscriminatorParam string `json:"type"`
		MarshalTypeUpdateOcirContainerScanRegistryDetails
	}{
		"OCIR",
		(MarshalTypeUpdateOcirContainerScanRegistryDetails)(m),
	}

	return json.Marshal(&s)
}
